"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletButton = exports.WalletHeader = exports.rescanModalDialog = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const walletSection_1 = require("../../state/ducks/walletSection");
const BchatButton_1 = require("../basic/BchatButton");
const BchatIcon_1 = require("../icon/BchatIcon");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const wallet_1 = require("../../state/ducks/wallet");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const utils_1 = require("../../bchat/utils");
const walletConfig_2 = require("../../state/selectors/walletConfig");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const Avatar_1 = require("../avatar/Avatar");
async function rescanModalDialog(rescaning, dispatch) {
    if (!window.globalOnlineStatus) {
        return utils_1.ToastUtils.pushToastError('internetConnectionError', 'Please check your internet connection');
    }
    let rescan = true;
    let Transactions = '';
    let wallHeight = 0;
    dispatch((0, modalDialog_1.updateConfirmModal)({
        title: window.i18n('rescanWallet'),
        message: window.i18n('rescanWalletDiscription'),
        okTheme: BchatButton_1.BchatButtonColor.Primary,
        okText: window.i18n('Rescan'),
        btndisable: rescaning,
        iconShow: true,
        customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'rotatedArrow', iconSize: 30 }),
        onClickOk: () => {
            dispatch((0, walletConfig_1.updateWalletRescaning)(rescan));
            dispatch((0, walletConfig_1.updateFiatBalance)(Transactions));
            window.setSettingValue('syncStatus', false);
            dispatch((0, wallet_1.updateBalance)({
                balance: 0,
                unlocked_balance: 0,
                transacations: [],
            }));
            dispatch((0, walletConfig_1.updateWalletHeight)(wallHeight));
            wallet_rpc_1.wallet.rescanBlockchain();
        },
    }));
}
exports.rescanModalDialog = rescanModalDialog;
const WalletHeader = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const ourPubkey = utils_1.UserUtils.getOurPubKeyFromCache();
    const syncStatus = (0, react_redux_1.useSelector)(walletConfig_2.getRescaning);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(ourPubkey);
    return (react_1.default.createElement("div", { className: "wallet-header" },
        react_1.default.createElement("div", { className: "wallet-header-left-side" },
            react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: ourPubkey, isBnsHolder: isBnsHolder }),
            react_1.default.createElement("span", { className: "header-txt" }, window.i18n('WalletSettingsTitle'))),
        react_1.default.createElement("div", { className: "wallet-header-right-side" },
            react_1.default.createElement("div", { className: "wallet-header-left-side-btn-box", style: { marginRight: '15px' } },
                react_1.default.createElement(BchatButton_1.BchatButton, { iconType: "addressBook", iconSize: 20, fillRule: "evenodd", clipRule: "evenodd", text: "Address Book", buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Secondary, onClick: () => {
                        dispatch((0, walletSection_1.addressbook)());
                    } })),
            react_1.default.createElement(exports.WalletButton, { icontype: "rotatedArrow", iconSize: 20, submit: () => {
                    rescanModalDialog(!syncStatus, dispatch);
                } }))));
};
exports.WalletHeader = WalletHeader;
const WalletButton = (props) => {
    const { icontype, iconSize, submit } = props;
    return (react_1.default.createElement("div", { className: "wallet-button", onClick: () => submit() },
        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: iconSize, iconType: icontype })));
};
exports.WalletButton = WalletButton;
