"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BalanceAndsendReceiveAction = exports.Dashboard = exports.WalletMainPanel = exports.WalletDashboard = exports.WalletPage = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatWalletAddressBook_1 = require("./BchatWalletAddressBook");
const BchatWalletBalanceSection_1 = require("./BchatWalletBalanceSection");
const BchatWalletHeader_1 = require("./BchatWalletHeader");
const BchatWalletPaymentSection_1 = require("./BchatWalletPaymentSection");
const BchatWalletSendForm_1 = require("./BchatWalletSendForm");
const BchatWalletTransactionSection_1 = require("./BchatWalletTransactionSection");
const BchatWalletSyncSatusBar_1 = require("./BchatWalletSyncSatusBar");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const utils_1 = require("../../bchat/utils");
const classnames_1 = __importDefault(require("classnames"));
const modal_1 = require("../../state/selectors/modal");
const styled_components_1 = __importDefault(require("styled-components"));
const BchatWalletReceivedForm_1 = require("./BchatWalletReceivedForm");
const settings_key_1 = require("../../data/settings-key");
var WalletPage;
(function (WalletPage) {
    WalletPage["WalletPassword"] = "walletPassword";
    WalletPage["Dashboard"] = "dashboard";
    WalletPage["AddressBook"] = "addressbook";
    WalletPage["Contact"] = "contact";
})(WalletPage = exports.WalletPage || (exports.WalletPage = {}));
var WalletDashboard;
(function (WalletDashboard) {
    WalletDashboard["walletSend"] = "walletSend";
    WalletDashboard["walletReceived"] = "walletReceived";
})(WalletDashboard = exports.WalletDashboard || (exports.WalletDashboard = {}));
const WalletMainPanel = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const walletDetails = (0, react_redux_1.useSelector)((state) => state.wallet);
    const [amount, setAmount] = (0, react_1.useState)('');
    const [notes, setNotes] = (0, react_1.useState)('');
    const BchatWalletPasswordModal = (0, react_redux_1.useSelector)(modal_1.getBchatWalletPasswordModal);
    let decimalValue = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal) || '2 - Two (0.00)';
    decimalValue = decimalValue.charAt(0);
    if (!window.globalOnlineStatus) {
        utils_1.ToastUtils.pushToastError('internetConnectionError', 'Please check your internet connection');
    }
    function numberOnly(e) {
        const pattern = /^(\d{0,16}(\.\d{1,5})?|(\d{0,16}\.))$/;
        if (e === '' || pattern.test(e)) {
            setAmount(e);
        }
    }
    function clearStates() {
        setAmount('');
        setNotes('');
        let emptyAddress = '';
        dispatch((0, walletConfig_1.updateSendAddress)(emptyAddress));
    }
    function fillAmount() {
        setAmount((walletDetails.balance / 1e9).toFixed(decimalValue));
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('wallet', BchatWalletPasswordModal && 'blurBg') },
        react_1.default.createElement(exports.Dashboard, { amount: amount, setAmount: (e) => {
                numberOnly(e);
            }, notes: notes, setNotes: (e) => setNotes(e), clearStates: () => clearStates(), fillAmount: () => fillAmount() })));
};
exports.WalletMainPanel = WalletMainPanel;
const Dashboard = (props) => {
    const focusedsettings = (0, react_redux_1.useSelector)((state) => state.walletFocused);
    const focusedInnersection = (0, react_redux_1.useSelector)((state) => state.walletInnerFocused);
    let transactions = (0, react_redux_1.useSelector)((state) => state.wallet.transacations);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    const syncBar = window.getSettingValue('sync_bar');
    const getSyncStatus = window.getSettingValue('syncStatus');
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(BchatWalletHeader_1.WalletHeader, null),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement(SyncStatusBox, { width: syncBar, color: getSyncStatus },
            react_1.default.createElement(BchatWalletSyncSatusBar_1.MemoSyncStatusBar, null)),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "wallet-contentSpace" },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", width: "100%" },
                react_1.default.createElement(Leftpane, { zoomFactor: zoomLevel },
                    react_1.default.createElement(BchatWalletBalanceSection_1.WalletBalanceSection, null),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    WalletPage.AddressBook === focusedsettings ? (react_1.default.createElement("div", { className: 'address-book-wrapper' },
                        react_1.default.createElement(BchatWalletAddressBook_1.AddressBook, { isContact: false }))) : (react_1.default.createElement(BchatWalletTransactionSection_1.TransactionSection, { transactionList: transactions }))),
                react_1.default.createElement(RightPane, { zoomFactor: zoomLevel },
                    react_1.default.createElement(BchatWalletPaymentSection_1.WalletPaymentSection, { clearStates: props.clearStates }),
                    WalletDashboard.walletSend === focusedInnersection && (react_1.default.createElement(BchatWalletSendForm_1.SendForm, { amount: props.amount, setAmount: props.setAmount, notes: props.notes, setNotes: props.setNotes, fillAmount: props.fillAmount })),
                    WalletDashboard.walletReceived === focusedInnersection && react_1.default.createElement(BchatWalletReceivedForm_1.ReceivedForm, null))))));
};
exports.Dashboard = Dashboard;
const BalanceAndsendReceiveAction = (props) => {
    return (react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", justifyContent: "space-between" },
        react_1.default.createElement(BchatWalletBalanceSection_1.WalletBalanceSection, null),
        react_1.default.createElement(BchatWalletPaymentSection_1.WalletPaymentSection, { clearStates: props.clearStates })));
};
exports.BalanceAndsendReceiveAction = BalanceAndsendReceiveAction;
const Leftpane = styled_components_1.default.div `
  // width:45vw;
  // height:${props => props.zoomFactor == 125 ? '76vh' : props.zoomFactor == 150 && window.innerWidth < 1100 ? '74vh' : props.zoomFactor == 150 ? '73vh' : '79vh'};
  // height:79vh
  margin-right: 15px;
  overflow:${props => props.zoomFactor > 100 ? 'auto' : ''};
`;
const RightPane = styled_components_1.default.div `
  // width: 25vw;
  width: 50%;
  min-width:${props => props.zoomFactor ? '260px' : '320px'} ;

  // height: ${props => props.zoomFactor == 125 ? '76vh' : props.zoomFactor == 150 && window.innerWidth < 1100 ? '73.7vh' : props.zoomFactor == 150 ? '73vh' : '82vh'} ;
  // height:78vh;
  border-radius: 16px;
  background: var(--color-wallet-inner-bg);
  overflow:auto;
`;
const SyncStatusBox = styled_components_1.default.div `
  position: relative;

  &:after {
    content: '';
    position: absolute;
    bottom: 0px;
    left: ;
    padding: 10px;
    width: ${props => (props.width ? `${props.width}%` : '10%')};
    border-bottom: 2px solid ${props => (props.color ? '#1DBF25' : '#FDB12A')};
    transition: width 3s ease-in-out;
    border-bottom-left-radius: 12px;
    border-bottom-right-radius: ${props => ((props.width == '100.0') ? '12px' : 'none')};

`;
