"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletModal = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const BchatButton_1 = require("../basic/BchatButton");
const Text_1 = require("../basic/Text");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const icon_1 = require("../icon");
const bchat_1 = require("../../bchat");
const WalletModal = (props) => {
    const [select, setSelect] = (0, react_1.useState)(props.currency);
    const [data, setData] = (0, react_1.useState)(props.content);
    const [searchTerm, setSearchTerm] = (0, react_1.useState)('');
    const { needSearch } = props;
    function search(sTerm) {
        setSearchTerm(sTerm.trim());
        if (sTerm.trim() !== '') {
            const filtered = props.content.filter((item) => item.toLowerCase().includes(sTerm.toLowerCase()));
            setData(filtered);
        }
        else {
            setData(props.content);
        }
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: props.headerName, onClose: props.onClose, showExitIcon: false, okButton: {
                text: window.i18n('save'),
                color: BchatButton_1.BchatButtonColor.Primary,
                onClickOkHandler: () => {
                    props.onClick(select);
                },
            }, cancelButton: {
                status: true,
                text: window.i18n('cancel'),
                onClickCancelHandler: props.onClose,
            } },
            react_1.default.createElement("div", null,
                needSearch && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(Text_1.SpacerSM, null),
                    react_1.default.createElement("div", null,
                        react_1.default.createElement("div", { className: "currency-search" },
                            react_1.default.createElement("div", { className: "search" },
                                react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
                            react_1.default.createElement("input", { value: searchTerm, onChange: e => {
                                    const inputValue = e.target.value;
                                    search(inputValue);
                                }, placeholder: 'Search Currency', maxLength: 26 }))),
                    react_1.default.createElement(Text_1.SpacerSM, null))),
                react_1.default.createElement("div", { className: "bchat-modal__walletModel", style: { height: needSearch ? '300px' : "" } },
                    react_1.default.createElement("div", { style: { width: '100%', overflowY: 'auto' } }, data?.length !== 0 &&
                        data.map((item, i) => (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-modal__centered-walletModalContent', select === item && 'isSelect'), key: i, onClick: () => setSelect(item) },
                                react_1.default.createElement("div", { className: select !== item
                                        ? 'bchat-modal__centered-walletModalContent-circle'
                                        : 'selected' }, select === item && (react_1.default.createElement(icon_1.BchatIcon, { iconType: "circle", iconSize: 10, iconColor: bchat_1.Constants.UI.COLORS.GREEN }))),
                                item),
                            react_1.default.createElement(Text_1.SpacerSM, null))))))))));
};
exports.WalletModal = WalletModal;
