"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeSetting = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const BchatButton_1 = require("../basic/BchatButton");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatIcon_1 = require("../icon/BchatIcon");
const classnames_1 = __importDefault(require("classnames"));
const settings_key_1 = require("../../data/settings-key");
const BchatWalletHelper_1 = require("../../wallet/BchatWalletHelper");
const BchatWalletLocalDeamonsettings_1 = require("./BchatWalletLocalDeamonsettings");
const utils_1 = require("../../bchat/utils");
const react_use_1 = require("react-use");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const wallet_1 = require("../../state/ducks/wallet");
const icon_1 = require("../icon");
const theme_1 = require("../../state/selectors/theme");
const NodeSetting = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const currentDeamon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon)
        ? window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon)
        : window.currentDaemon;
    const deamonList = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDeamonList);
    const currentHost = currentDeamon.host == '127.0.0.1' ? window.currentDaemon.host : currentDeamon.host;
    const currentPort = currentDeamon.host == '127.0.0.1' ? window.currentDaemon.port : currentDeamon.port;
    const [viewBox1, setViewBox1] = (0, react_1.useState)(false);
    const [viewBox2, setViewBox2] = (0, react_1.useState)(false);
    const [ipAddress, setIpAddress] = (0, react_1.useState)('');
    const [port, setPort] = (0, react_1.useState)('');
    const [dropdown, setDropdown] = (0, react_1.useState)(false);
    const [chooseDeamon, setChooseDeamon] = (0, react_1.useState)(currentHost);
    const [chooseDeamonPort, setChooseDeamonPort] = (0, react_1.useState)(currentPort);
    const [option, setOption] = (0, react_1.useState)(deamonList);
    const [verifyDeamon, setVerifyDeamon] = (0, react_1.useState)({});
    const [testNotify, setTestNotify] = (0, react_1.useState)({ status: '', content: '', StatusIcon: true });
    const [testbtnDisable, setTestbtnDisable] = (0, react_1.useState)(false);
    const [localDeamonVisible, setLocalDeamonVisible] = (0, react_1.useState)(false);
    const modalRef = (0, react_1.useRef)(null);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    const testBottonEnable = !(ipAddress && port);
    const savebtnValidation = currentDeamon.host === chooseDeamon && currentDeamon.port === chooseDeamonPort;
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    (0, react_1.useEffect)(() => {
        document.addEventListener('click', handleClick);
        return () => {
            document.removeEventListener('click', handleClick);
        };
    }, []);
    function portValidation(value) {
        const regex = /^[0-9\b]+$/;
        if (value === '' || regex.test(value)) {
            setPort(value);
            setVerifyDeamon({});
            setTestNotify({ status: '', content: ``, StatusIcon: true });
        }
    }
    function assignHost(e) {
        setIpAddress(e);
        setVerifyDeamon({});
        setTestNotify({ status: '', content: ``, StatusIcon: true });
    }
    function addDeamonNet() {
        let data = verifyDeamon;
        if (Object.keys(data).length === 0) {
            return;
        }
        data.type = 'Remote';
        let deamon_list = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDeamonList);
        let checkVerifiedDaemon = deamon_list.find((daemon) => daemon.host == data.host);
        if (checkVerifiedDaemon) {
            return utils_1.ToastUtils.pushToastInfo('daemonAlreadyAdded', `This daemon already added.`);
        }
        if (deamon_list) {
            deamon_list.push(data);
        }
        window.setSettingValue(settings_key_1.walletSettingsKey.settingsDeamonList, deamon_list);
        setOption(deamon_list);
        assignHost('');
        setPort('');
        setVerifyDeamon({});
        setTestNotify({ status: '', content: '', StatusIcon: true });
        return utils_1.ToastUtils.pushToastSuccess('daemonAddedSuccessfully', `Daemon added successfully.`);
    }
    function currentDeamonNet() {
        let choosenDaemon = { host: chooseDeamon, port: chooseDeamonPort, active: 1, type: 'Remote' };
        window.setSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon, choosenDaemon);
        let rescan = true;
        let Transactions = '';
        let wallHeight = 0;
        dispatch((0, walletConfig_1.updateWalletRescaning)(rescan));
        dispatch((0, walletConfig_1.updateFiatBalance)(Transactions));
        window.setSettingValue('syncStatus', false);
        dispatch((0, wallet_1.updateBalance)({
            balance: 0,
            unlocked_balance: 0,
            transacations: [],
        }));
        dispatch((0, walletConfig_1.updateWalletHeight)(wallHeight));
        utils_1.ToastUtils.pushToastSuccess('successfully-updated-current-daemon', `Successfully ${choosenDaemon.host}:${choosenDaemon.port} daemon updated.`);
        setDropdown(false);
    }
    async function showDropDown() {
        setViewBox2(!viewBox2);
        let data = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDeamonList);
        let status = [];
        for (let i = 0; i < data.length; i++) {
            if (data[i].type == 'Remote') {
                const deamonStatus = await (0, BchatWalletHelper_1.workingStatusForDeamon)(data[i], 'daemonValidation');
                if (deamonStatus.status === 'OK') {
                    data[i].active = true;
                    status.push(data[i]);
                }
                else {
                    data[i].active = false;
                    status.push(data[i]);
                }
            }
        }
        setOption(status);
        setViewBox2(!viewBox2);
    }
    function AssignCurrentDeamon(item) {
        setChooseDeamon(item.host);
        setDropdown(false);
        setChooseDeamonPort(item.port);
    }
    const handleClick = (e) => {
        if (!modalRef.current?.contains(e.target)) {
            setDropdown(false);
        }
    };
    (0, react_use_1.useKey)((event) => {
        if (!localDeamonVisible && event.key === 'Enter') {
            if (!testBottonEnable) {
                validationForDeamon();
            }
            if (Object.keys(verifyDeamon).length !== 0) {
                addDeamonNet();
            }
        }
        return event.key === 'Enter';
    });
    async function validationForDeamon() {
        setTestbtnDisable(true);
        let data = { host: ipAddress, port: port, active: 1, type: 'Remote' };
        const confirmation = await (0, BchatWalletHelper_1.workingStatusForDeamon)(data, 'daemonValidation');
        if (confirmation && confirmation.status === 'OK') {
            if (confirmation.nettype === window.networkType) {
                setVerifyDeamon(data);
                setTestNotify({ status: 'ok', content: `Success`, StatusIcon: true });
                return;
            }
            setTestNotify({
                status: 'ok',
                content: `You're using ${confirmation.nettype} IP. Use a ${window.networkType} IP`,
                StatusIcon: false,
            });
            return;
        }
        setTestNotify({ status: 'failed', content: `Error`, StatusIcon: true });
        setVerifyDeamon({});
        setTestbtnDisable(false);
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { style: { cursor: 'pointer' } },
            react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center" },
                react_1.default.createElement("div", { className: "marginRight" },
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: "walletBackArrow", iconSize: 'medium', iconColor: darkMode ? '#F0F0F0' : '#333333', onClick: () => props.onClick() })),
                react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" }, window.i18n('node')))),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("section", { className: "wallet-settings-nodeSetting-contentBox" },
            react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center", flexDirection: "row", width: "100%", justifyContent: "flex-start", style: { fontSize: '16px' } },
                react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-FlexBox" },
                    react_1.default.createElement("div", { onClick: () => setLocalDeamonVisible(false), className: "wallet-settings-nodeSetting-FlexBox-outlineCircle", style: !localDeamonVisible
                            ? { border: '2px solid var(--color-walletNodeHeader)' }
                            : { border: '2px solid var(--color-radio-icon)' } }, !localDeamonVisible && (react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circle", iconSize: 11, iconColor: "var(--color-walletNodeHeader)" }))),
                    react_1.default.createElement("div", { className: "marginLeft wallet-settings-nodeSetting-FlexBox-radio-label" },
                        ' ',
                        window.i18n('remoteDaemonOnly'))),
                react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-FlexBox", style: { marginLeft: '50px' } },
                    react_1.default.createElement("div", { onClick: () => {
                            setLocalDeamonVisible(true);
                            setTestNotify({ status: '', content: '', StatusIcon: true });
                            setIpAddress('');
                            setPort('');
                            setVerifyDeamon({});
                        }, className: "wallet-settings-nodeSetting-FlexBox-outlineCircle", style: localDeamonVisible
                            ? { border: '2px solid var(--color-walletNodeHeader)' }
                            : { border: '2px solid var(--color-radio-icon)' } }, localDeamonVisible && (react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circle", iconSize: 11, iconColor: "var(--color-walletNodeHeader)" }))),
                    react_1.default.createElement("div", { className: "marginLeft wallet-settings-nodeSetting-FlexBox-radio-label" },
                        ' ',
                        window.i18n('localDaemonOnly')))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-notesTxt" }, localDeamonVisible
                ? window.i18n('localDeamonheadetcntent')
                : window.i18n('remoteNoteToAllTransactions')),
            react_1.default.createElement(Text_1.SpacerLG, null),
            localDeamonVisible ? (react_1.default.createElement(BchatWalletLocalDeamonsettings_1.LocalDeamon, null)) : (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(Flex_1.Flex, { className: "wallet-settings-nodeSetting-dropDownHeaderTxt", container: true, justifyContent: "space-between", cursor: 'pointer', onClick: () => setViewBox1(!viewBox1) },
                    react_1.default.createElement("div", { className: "text" }, window.i18n('addRemoteDaemonNode')),
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconColor: "#A7A7BA", iconType: "chevron", iconSize: 'small', iconRotation: viewBox1 ? 178 : 0 }))),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement("div", { className: (0, classnames_1.default)('wallet-settings-nodeSetting-remoteContentBox-content-hidden-Box'), style: viewBox1 ? { display: 'block' } : {} },
                    react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between" },
                        react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('remoteNodeHost')),
                            react_1.default.createElement("input", { value: ipAddress, placeholder: "Enter your IP address", className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-input", onChange: (e) => {
                                    assignHost(e.target.value);
                                }, style: zoomLevel > 125 ? { paddingLeft: '10px' } : {} })),
                        react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('remoteNodePort')),
                            react_1.default.createElement("input", { value: port, className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-input", onChange: (e) => portValidation(e.target.value), placeholder: "Enter your port", style: zoomLevel > 125 ? { paddingLeft: '10px' } : {}, maxLength: 5 }))),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-FlexBox wallet-settings-nodeSetting-remoteContentBox-btnBox" },
                        react_1.default.createElement("div", null,
                            react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: !testBottonEnable ? BchatButton_1.BchatButtonColor.Primary : BchatButton_1.BchatButtonColor.Secondary, text: window.i18n('test'), onClick: () => !testBottonEnable && !testbtnDisable && validationForDeamon(), style: { cursor: !testBottonEnable ? 'pointer' : 'default' }, disabled: testbtnDisable })),
                        react_1.default.createElement("div", { style: { marginLeft: '15px' } }),
                        react_1.default.createElement("div", null,
                            react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: Object.keys(verifyDeamon).length !== 0
                                    ? BchatButton_1.BchatButtonColor.Primary
                                    : BchatButton_1.BchatButtonColor.Secondary, text: window.i18n('add'), onClick: () => Object.keys(verifyDeamon).length !== 0 && addDeamonNet(), style: {
                                    cursor: Object.keys(verifyDeamon).length !== 0 ? 'pointer' : 'default',
                                } }))),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    testNotify.status && (react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-warning-box" },
                        react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement("span", { className: "result" }, window.i18n('NodeTestResult')),
                            react_1.default.createElement("span", { className: "result-msg" },
                                "Connection : ",
                                react_1.default.createElement("span", { className: "error-msg" }, testNotify.content)),
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: testNotify.status === 'ok' ? 'check' : 'warning', iconSize: 20, iconColor: testNotify.status === 'ok' ? 'green' : 'red', iconPadding: '0 0 0 3px' }))))),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement(Flex_1.Flex, { className: "wallet-settings-nodeSetting-dropDownHeaderTxt", container: true, justifyContent: "space-between", cursor: 'pointer', onClick: () => showDropDown() },
                    react_1.default.createElement("div", { className: "text" }, window.i18n('chooseRemoteDaemonNode')),
                    react_1.default.createElement("div", { style: { cursor: 'pointer' } },
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconColor: "#A7A7BA", iconType: "chevron", iconSize: 'small', iconRotation: viewBox2 ? 178 : 0 }))),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement("div", { className: (0, classnames_1.default)('wallet-settings-nodeSetting-remoteContentBox-content-hidden-Box'), style: viewBox2 ? { display: 'block' } : {} },
                    react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between" },
                        react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('remoteNodeHost')),
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-inputBox", style: { flexDirection: 'column', padding: 0 }, ref: modalRef },
                                react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-inputBox", style: { width: '100%' } },
                                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-dropdown", style: { padding: 0 } },
                                        react_1.default.createElement("input", { value: chooseDeamon, className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-dropdown", style: { width: '95%', padding: 0 }, disabled: true, placeholder: "Choose your daemon IP" })),
                                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-dropDownBtn", onClick: () => setDropdown(!dropdown) },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: 20, iconType: "chevron", iconColor: "#A7A7BA" }))),
                                react_1.default.createElement("div", { style: { width: '100%' } }, dropdown && (react_1.default.createElement("div", { style: { position: 'relative', zIndex: 1 } },
                                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-dropDownModal" }, option.length > 0 &&
                                        option.map((item, i) => (react_1.default.createElement("div", { style: { cursor: 'pointer' }, key: i, className: "wallet-settings-nodeSetting-dropDownModal-items", onClick: () => AssignCurrentDeamon(item) },
                                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circle", iconSize: 8, iconColor: item.active ? '#108D32' : '#FF3E3E' }),
                                            react_1.default.createElement("span", { style: { marginLeft: '10px', color: item.active ? '' : 'red' } },
                                                item.host,
                                                ":",
                                                item.port)))))))))),
                        react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('remoteNodePort')),
                            react_1.default.createElement("input", { value: chooseDeamonPort, className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-input", disabled: true, placeholder: "Choose your daemon port" }))),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center" },
                        react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: savebtnValidation ? BchatButton_1.BchatButtonColor.Secondary : BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand, text: window.i18n('save'), onClick: () => !savebtnValidation && currentDeamonNet(), style: { cursor: savebtnValidation ? 'default' : 'pointer' } })),
                    react_1.default.createElement(Text_1.SpacerLG, null)))))));
};
exports.NodeSetting = NodeSetting;
