"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletPassword = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const Text_1 = require("../basic/Text");
const settings_key_1 = require("../../data/settings-key");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const BchatWalletProgressForSync_1 = require("./BchatWalletProgressForSync");
const walletConfig_2 = require("../../state/selectors/walletConfig");
const BchatWalletHelper_1 = require("../../wallet/BchatWalletHelper");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const WalletPassword = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    let currentHeight;
    let daemonHeight;
    const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
    if (currentDaemon?.type === 'Local') {
        currentHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
        daemonHeight = Number((0, react_redux_1.useSelector)(walletConfig_2.getHeight));
    }
    else {
        currentHeight = Number((0, react_redux_1.useSelector)(walletConfig_2.getHeight));
        daemonHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
    }
    const { password, onChangePassword } = props;
    let pct = currentHeight == 0 || daemonHeight == 0 ? 0 : ((100 * currentHeight) / daemonHeight).toFixed(0);
    let percentage = pct == 100 && currentHeight < daemonHeight ? 99 : pct;
    function loadDecimal() {
        if (!window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal)) {
            let data = '2 - Two (0.00)';
            window.setSettingValue('decimal', data);
            dispatch((0, walletConfig_1.updateDecimalValue)(data));
        }
        else {
            let data = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal);
            dispatch((0, walletConfig_1.updateDecimalValue)(data));
        }
    }
    loadDecimal();
    (0, BchatWalletHelper_1.loadRecipient)();
    (0, BchatWalletHelper_1.loadFiatCurrency)();
    if (daemonHeight > 0 && percentage < 99) {
        return (react_1.default.createElement(BchatWalletProgressForSync_1.ProgressForSync, { remainingHeight: daemonHeight - currentHeight, percentage: percentage }));
    }
    return (react_1.default.createElement("div", { className: "wallet-walletPassword" },
        react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox" },
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox-walletImg" }),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox-headerBox" },
                react_1.default.createElement("span", null, window.i18n('enterWalletPassword'))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox-inputBox" },
                react_1.default.createElement("input", { type: "password", autoFocus: true, value: password, maxLength: 13, placeholder: "Enter wallet password", onChange: e => onChangePassword(e.target.value) })),
            props.from === 'wallet' && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox-forgotTxt" },
                    react_1.default.createElement("span", { onClick: () => { dispatch((0, modalDialog_1.updateBchatWalletForgotPasswordModal)({})); }, style: { cursor: 'pointer' } }, window.i18n('forgotPassword'))))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(Text_1.SpacerMD, null))));
};
exports.WalletPassword = WalletPassword;
