"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletPaymentSection = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const walletInnerSection_1 = require("../../state/ducks/walletInnerSection");
const Flex_1 = require("../basic/Flex");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWalletMainPanel_1 = require("./BchatWalletMainPanel");
const WalletPaymentSection = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const focusedInnersection = (0, react_redux_1.useSelector)((state) => state.walletInnerFocused);
    function tabBtn() {
        props.clearStates();
        dispatch((0, walletInnerSection_1.walletSendPage)());
    }
    return (react_1.default.createElement("div", { className: "wallet-squarBox-tran" },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center", height: "100%" },
            react_1.default.createElement("div", { className: "wallet-btn-wrapper" },
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", justifyContent: "center" },
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('send'), iconSize: "small", iconType: "paySend", onClick: () => tabBtn(), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatWalletMainPanel_1.WalletDashboard.walletSend === focusedInnersection
                            ? BchatButton_1.BchatButtonColor.Primary
                            : BchatButton_1.BchatButtonColor.Secondary, style: { minWidth: 'unset', width: '45%' } }),
                    react_1.default.createElement("span", { style: { width: '5%', height: '20px' } }),
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('received'), iconSize: "small", iconType: "payRecieved", buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatWalletMainPanel_1.WalletDashboard.walletReceived === focusedInnersection
                            ? BchatButton_1.BchatButtonColor.Primary
                            : BchatButton_1.BchatButtonColor.Secondary, onClick: () => {
                            dispatch((0, walletInnerSection_1.walletReceivedPage)());
                        }, style: { minWidth: 'unset', width: '45%' } }))))));
};
exports.WalletPaymentSection = WalletPaymentSection;
