"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgressForSync = void 0;
const react_1 = __importDefault(require("react"));
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const react_circular_progressbar_1 = require("react-circular-progressbar");
const styled_components_1 = __importDefault(require("styled-components"));
const ProgressForSync = (props) => {
    return (react_1.default.createElement("div", { className: "wallet-walletPassword " },
        react_1.default.createElement("div", { className: "wallet-walletPassword-contentBox progressSyncBox" },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: 'progress' },
                react_1.default.createElement(react_circular_progressbar_1.CircularProgressbarWithChildren, { value: props.percentage },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 40, iconType: 'wallet' }))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-progressSync-presentage" },
                props.percentage,
                "%"),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-progressSync-reloadTxt" },
                react_1.default.createElement("span", null, window.i18n('almostThere')),
                react_1.default.createElement("span", { style: { marginRight: '5px' } }, window.i18n('walletSyncingNow')),
                react_1.default.createElement(icon_1.BchatIcon, { iconType: "rotatedArrow", iconSize: 'small' })),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "wallet-progressSync-bRemaing" },
                react_1.default.createElement(RemainHeight, null, props.remainingHeight),
                react_1.default.createElement("span", null, window.i18n('blocksRemaining'))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(Text_1.SpacerLG, null))));
};
exports.ProgressForSync = ProgressForSync;
const RemainHeight = styled_components_1.default.span `
color: #108D32;
font-size: 18px;
font-weight: 700;
margin-right: 5px;`;
