"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceivedForm = void 0;
const react_1 = __importStar(require("react"));
const Text_1 = require("../basic/Text");
const react_qrcode_logo_1 = require("react-qrcode-logo");
const EditProfileDialog_1 = require("../dialog/EditProfileDialog");
const BchatButton_1 = require("../basic/BchatButton");
const ReceivedForm = () => {
    const walletAddress = localStorage.getItem('userAddress');
    const [txnAmount, setTxnAmount] = (0, react_1.useState)('');
    const qrValue = `Beldex:${walletAddress}?tx_amount=${txnAmount}`;
    function validator(e) {
        const pattern = /^(\d{0,16}(\.\d{1,5})?|(\d{0,16}\.))$/;
        if (e === '' || pattern.test(e)) {
            setTxnAmount(e);
        }
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: "wallet-receivedForm" },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("h5", { className: "wallet-receivedForm-title" }, "Primary Account"),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("section", { className: "wallet-receivedForm-qrBox" },
                react_1.default.createElement("div", { className: "wallet-receivedForm-qrBox-qrView" },
                    react_1.default.createElement(react_qrcode_logo_1.QRCode, { value: qrValue, bgColor: "#d9d9d9", fgColor: "#1B1B1B", ecLevel: "M", size: 160, style: { width: '165px', height: "165px" }, qrStyle: 'squares', logoImage: 'images/wallet/beldex_watermark_qr.svg' }))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('copyAddress'), iconType: "copy", iconSize: 'small', clipRule: "evenodd", fillRule: "evenodd", buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => (0, EditProfileDialog_1.copyBchatID)(walletAddress) }),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-receivedForm-rightSide" },
                react_1.default.createElement("div", { className: "wallet-receivedForm-rightSide-label" }, window.i18n('hintReceiveBDX')),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", null,
                    react_1.default.createElement("input", { value: txnAmount, className: "wallet-receivedForm-rightSide-input", placeholder: window.i18n('enterAmount'), type: "text", onChange: (e) => validator(e.target.value), maxLength: 16 })),
                react_1.default.createElement(Text_1.SpacerLG, null)))));
};
exports.ReceivedForm = ReceivedForm;
