"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoSyncStatusBar = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const Flex_1 = require("../basic/Flex");
const walletConfig_2 = require("../../state/ducks/walletConfig");
const settings_key_1 = require("../../data/settings-key");
const SyncStatusBar = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    let currentHeight;
    let daemonHeight;
    const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    let decimalValue = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal) || '2 - Two (0.00)';
    decimalValue = decimalValue.charAt(0);
    if (currentDaemon?.type === 'Local') {
        currentHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
        daemonHeight = Number((0, react_redux_1.useSelector)(walletConfig_1.getHeight));
    }
    else {
        currentHeight = Number((0, react_redux_1.useSelector)(walletConfig_1.getHeight));
        daemonHeight = (0, react_redux_1.useSelector)((state) => state.daemon.height);
    }
    let pct = currentHeight == 0 || daemonHeight == 0 ? 0 : ((100 * currentHeight) / daemonHeight).toFixed(1);
    let percentage = pct == 100.0 && currentHeight < daemonHeight ? 99.9 : pct;
    window.setSettingValue('sync_bar', percentage);
    const getSyncStatus = window.getSettingValue('syncStatus');
    const syncStatus = getSyncStatus
        ? { color: '#1DBF25', status: 'Synchronized' }
        : { color: '#FDB12A', status: 'Scanning' };
    window.setSettingValue('syncStatus', pct >= 99 ? true : false);
    let value = pct >= 99 ? true : false;
    dispatch((0, walletConfig_2.updateWalletRescaning)(value));
    return (react_1.default.createElement("div", { className: "syncStatus", style: { height: zoomLevel > 125 ? 'unset' : '' } },
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", alignItems: "center", padding: '5px 15px', height: zoomLevel > 125 ? "" : "100%" },
            react_1.default.createElement(Flex_1.Flex, { container: true },
                react_1.default.createElement("div", { className: "syncStatus-statusTxt-wrapper" },
                    react_1.default.createElement("span", { className: "txt" }, "Status "),
                    react_1.default.createElement("span", { className: "syncStatus-statusTxt-greenTxt", style: { color: syncStatus.color } }, syncStatus.status))),
            react_1.default.createElement(Flex_1.Flex, { container: true },
                react_1.default.createElement("div", { className: "syncStatus-statusvalue" },
                    react_1.default.createElement("span", { className: "type-txt" },
                        window.getSettingValue('current-deamon')?.type,
                        " :"),
                    ' ',
                    react_1.default.createElement("span", { className: "type-value" }, daemonHeight)),
                react_1.default.createElement("div", { className: "syncStatus-statusvalue", style: { marginLeft: '10px' } },
                    react_1.default.createElement("span", { className: "type-txt" }, "Wallet :"),
                    ' ',
                    react_1.default.createElement("span", { className: "type-value" },
                        currentHeight,
                        " / ",
                        daemonHeight)),
                react_1.default.createElement("div", { className: "per-Wrapper", style: { marginLeft: '10px' } },
                    Math.floor(percentage),
                    "%")))));
};
exports.MemoSyncStatusBar = react_1.default.memo(SyncStatusBar);
