"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionSection = void 0;
const classnames_1 = __importDefault(require("classnames"));
const moment_1 = __importDefault(require("moment"));
const react_1 = __importStar(require("react"));
const data_1 = require("../../data/data");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatIcon_1 = require("../icon/BchatIcon");
const electron_1 = require("electron");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const icon_1 = require("../icon");
const EditProfileDialog_1 = require("../dialog/EditProfileDialog");
const TransactionSection = (props) => {
    const transactionsHistory = props.transactionList == undefined ? [] : props.transactionList;
    const [filter, setFilter] = (0, react_1.useState)(window.i18n('filterAll'));
    const [emptyScreen, setEmptyScreen] = (0, react_1.useState)(window.i18n('filterAll'));
    const [visible, setVisible] = (0, react_1.useState)(false);
    const [data, setData] = (0, react_1.useState)(transactionsHistory);
    const [searchData, setSearchData] = (0, react_1.useState)([]);
    const [selected, setSelected] = (0, react_1.useState)(null);
    const [receipientData, setRecipientdata] = (0, react_1.useState)([]);
    const [searchText, setSearchText] = (0, react_1.useState)('');
    const syncStatus = (0, react_redux_1.useSelector)(walletConfig_1.getRescaning);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const recip = receipientData;
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    (0, react_1.useEffect)(() => {
        document.removeEventListener('click', handleClick);
        switch (filter) {
            case 'Outgoing':
                filterTransaction('out');
                break;
            case 'Pending':
                filterTransaction('pending');
                break;
            case 'Failed':
                filterTransaction('failed');
                break;
            case 'Incoming':
                filterTransaction('in');
                break;
            default:
                filterTransaction('All');
                break;
        }
        return () => {
            document.removeEventListener('click', handleClick);
        };
    }, [transactionsHistory]);
    const handleClick = (e) => {
        if (!modalRef.current?.contains(e.target)) {
            setVisible(!visible);
        }
    };
    function openToExplore(traxId) {
        if (window.networkType === 'mainnet') {
            void electron_1.shell.openExternal(`http://explorer.beldex.io/tx/${traxId}`);
        }
        else {
            void electron_1.shell.openExternal(`http://154.26.139.105/tx/${traxId}`);
        }
    }
    function closeDropDown(params, type) {
        setFilter(params);
        setEmptyScreen(params);
        setVisible(!visible);
        filterTransaction(type);
    }
    async function showdata(item, i) {
        if (selected === i) {
            setSelected(null);
        }
        else {
            setSelected(i);
        }
        if (item.type !== 'in') {
            let recipientAddress = await (0, data_1.getRecipientAddress)(item.txid);
            setRecipientdata(recipientAddress);
            return;
        }
        setRecipientdata([]);
    }
    const TransactionIndication = (props) => {
        const { type } = props;
        let item = {
            iconType: 'payRecieved',
            iconColor: '#00A638',
            type: window.i18n('received'),
        };
        switch (type) {
            case 'out':
                (item.iconType = 'paySend'),
                    (item.iconColor = '#FF3E3E'),
                    (item.type = window.i18n('sent'));
                break;
            case 'pending':
                (item.iconType = 'pendingTransaction'),
                    (item.iconColor = '#A7A7BA'),
                    (item.type = window.i18n('pending'));
                break;
            case 'bns':
                (item.iconType = 'bnsTransaction'),
                    (item.iconColor = 'var(--color-bns-transaction)'),
                    (item.type = window.i18n('bns'));
                break;
            case 'failed':
                (item.iconType = 'xWithCircle'),
                    (item.iconColor = '#FC2727'),
                    (item.type = window.i18n('failed'));
                break;
            default:
                break;
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: item.iconType, iconSize: 26, iconColor: item.iconColor, clipRule: "evenodd", fillRule: "evenodd" })));
    };
    function filterText(value) {
        var letters = /^[0-9a-zA-Z]+\.?\d*$/;
        if (value === '' || value.match(letters)) {
        }
        else {
            return;
        }
        setSearchText(value);
        searchTransaction(searchData);
    }
    function searchTransaction(filteredTransaction) {
        let data = filteredTransaction.length > 0
            ? filteredTransaction.filter((item) => String(item.amount / 1e9).includes(searchText.toLowerCase()) ||
                item.txid.toLowerCase().includes(searchText.toLowerCase()))
            : [];
        setData(data);
    }
    function filterTransaction(filterType) {
        let allTransaction;
        if (filterType === window.i18n('filterAll')) {
            allTransaction = transactionsHistory;
        }
        else {
            allTransaction =
                transactionsHistory.length > 0 &&
                    transactionsHistory.filter((data) => data.type === filterType);
        }
        setSearchData(allTransaction);
        if (searchText) {
            searchTransaction(allTransaction);
        }
        else {
            setData(allTransaction);
        }
    }
    const modalRef = (0, react_1.useRef)(null);
    return (react_1.default.createElement("div", { className: "wallet-Transaction", style: { height: zoomLevel > 100 ? 'unset' : '' } },
        react_1.default.createElement("div", { style: { height: '100%' }, onClick: () => (visible ? setVisible(false) : '') },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", width: "100%", justifyContent: "space-between" },
                react_1.default.createElement("div", { className: "wallet-Transaction-title" },
                    react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "oppositeDirDoubleArrow", iconSize: 20, clipRule: "evenodd", fillRule: "evenodd" }),
                    react_1.default.createElement("span", { style: { marginLeft: '10px' } }, window.i18n('transactions'))),
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "flex-end", flexDirection: "row", flexWrap: "wrap" },
                    transactionsHistory.length !== 0 || searchText ? (react_1.default.createElement("div", { className: "wallet-Transaction-filter-wrapper" },
                        react_1.default.createElement("input", { placeholder: window.i18n('filterPlaceHolder'), className: "wallet-Transaction-filterInput", onChange: (e) => filterText(e.target.value), value: searchText }),
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'funnelWithBorder', iconSize: 20, clipRule: "evenodd", fillRule: "evenodd" }))) : (''),
                    transactionsHistory.length > 0 && (react_1.default.createElement("div", { className: "wallet-Transaction-filterWithIcon" },
                        react_1.default.createElement("span", { className: "wallet-Transaction-filterWithIcon-inputBox" }, filter),
                        react_1.default.createElement("span", { onClick: () => setVisible(!visible), style: { cursor: 'pointer' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "filter", iconSize: 'medium', clipRule: "evenodd", fillRule: "evenodd" })),
                        visible && (react_1.default.createElement("div", { style: { position: 'relative' } },
                            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-sendDropDown" },
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(`dropDownItem `, filter === window.i18n('filterAll') && 'dropDownItem-selected'), onClick: () => closeDropDown(window.i18n('filterAll'), 'All') },
                                    filter === window.i18n('filterAll') ? (react_1.default.createElement("span", { className: (0, classnames_1.default)('dropDownItem-blockAndMargin') },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleTickOutline", iconColor: "#00A638", iconSize: 16 }))) : (react_1.default.createElement("span", { className: "dropDownItem-checkedCircle" })),
                                    window.i18n('filterAll')),
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(`dropDownItem `, filter === window.i18n('filterIncoming') && 'dropDownItem-selected'), onClick: () => closeDropDown(window.i18n('filterIncoming'), 'in') },
                                    filter === window.i18n('filterIncoming') ? (react_1.default.createElement("span", { className: "dropDownItem-blockAndMargin" },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleTickOutline", iconColor: "#00A638", iconSize: 16 }))) : (react_1.default.createElement("span", { className: "dropDownItem-checkedCircle" })),
                                    window.i18n('filterIncoming')),
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(`dropDownItem `, filter === window.i18n('filterOutgoing') && 'dropDownItem-selected'), onClick: () => closeDropDown(window.i18n('filterOutgoing'), 'out') },
                                    filter === window.i18n('filterOutgoing') ? (react_1.default.createElement("span", { className: "dropDownItem-blockAndMargin" },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleTickOutline", iconColor: "#00A638", iconSize: 16 }))) : (react_1.default.createElement("span", { className: "dropDownItem-checkedCircle" })),
                                    window.i18n('filterOutgoing')),
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(`dropDownItem `, filter === window.i18n('filterPending') && 'dropDownItem-selected'), onClick: () => closeDropDown(window.i18n('filterPending'), 'pending') },
                                    filter === window.i18n('filterPending') ? (react_1.default.createElement("span", { className: "dropDownItem-blockAndMargin" },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleTickOutline", iconColor: "#00A638", iconSize: 16 }))) : (react_1.default.createElement("span", { className: "dropDownItem-checkedCircle" })),
                                    window.i18n('filterPending')),
                                react_1.default.createElement("div", { className: (0, classnames_1.default)(`dropDownItem `, filter === window.i18n('failed') && 'dropDownItem-selected'), onClick: () => closeDropDown(window.i18n('failed'), 'failed') },
                                    filter === window.i18n('failed') ? (react_1.default.createElement("span", { className: "dropDownItem-blockAndMargin" },
                                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleTickOutline", iconColor: "#00A638", iconSize: 16 }))) : (react_1.default.createElement("span", { className: "dropDownItem-checkedCircle" })),
                                    window.i18n('failed'))))))))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-Transaction-parentBox" },
                data.length > 0 &&
                    data.map((item, i) => (react_1.default.createElement("div", { className: "wallet-Transaction-contentBox", key: i, onClick: () => showdata(item, i), style: { cursor: 'pointer' } },
                        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", flexDirection: "row", width: "100%", flexWrap: "wrap" },
                            react_1.default.createElement(Flex_1.Flex, { container: true, height: " 60px", margin: "15px 0 0 0" },
                                react_1.default.createElement("article", { className: "wallet-Transaction-contentBox-sendIndicationBox" },
                                    react_1.default.createElement(TransactionIndication, { type: item.type })),
                                react_1.default.createElement("div", { className: "wallet-Transaction-contentBox-balanceBox" },
                                    react_1.default.createElement("div", { className: "wallet-Transaction-contentBox-balanceBox-amount" },
                                        item.type === 'out' ? '-' : '',
                                        Number((item.amount / 1e9).toFixed(4)),
                                        " BDX"),
                                    react_1.default.createElement(Flex_1.Flex, { container: true },
                                        react_1.default.createElement(icon_1.BchatIconButton, { iconType: "copy", iconSize: 14, clipRule: "evenodd", fillRule: "evenodd", iconColor: "#108D32", onClick: () => (0, EditProfileDialog_1.copyBchatID)(item.txid) }),
                                        react_1.default.createElement("div", { className: "wallet-Transaction-contentBox-balanceBox-address", onClick: () => openToExplore(item.txid) }, item.txid)))),
                            react_1.default.createElement(Flex_1.Flex, { container: true, style: {
                                    marginLeft: zoomLevel > 125 && innerWidth < 1920 ? '38px' : '',
                                    marginTop: '15px',
                                } },
                                react_1.default.createElement("section", { className: "wallet-Transaction-contentBox-dateandheight" },
                                    react_1.default.createElement("div", { className: "wallet-Transaction-contentBox-dateandheight-month", style: {
                                            marginBottom: '7px',
                                            textAlign: zoomLevel > 125 && innerWidth < 1920 ? 'unset' : 'right',
                                        } }, moment_1.default.unix(item.timestamp).format('ll HH:mm')),
                                    react_1.default.createElement("div", { className: "wallet-Transaction-contentBox-dateandheight-height" },
                                        "Height : ",
                                        item.height,
                                        ' ',
                                        item.type === 'out' || item.type === 'in' ? '(confirmed)' : '')),
                                react_1.default.createElement(icon_1.BchatIconButton, { iconColor: darkMode ? '#A7A7BA' : '#3E4A53', iconType: "chevron", iconSize: 'medium', iconRotation: selected === i ? 178 : 0 }))),
                        selected === i && (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: recip.address && zoomLevel <= 100 ? 'space-between' : 'flex-start', flexDirection: "row", width: '100%' },
                                react_1.default.createElement(Flex_1.Flex, { container: true },
                                    react_1.default.createElement("article", { style: recip.address && zoomLevel > 100 ? { width: '30px' } : { width: '21px' } }),
                                    recip.address && (react_1.default.createElement("div", { style: { marginLeft: '20px', width: zoomLevel > 100 ? '65%' : '69%' }, className: "wallet-Transaction-recipitentBox-adddressBox" },
                                        react_1.default.createElement("span", null,
                                            window.i18n('recipientAddress'),
                                            " : "),
                                        react_1.default.createElement("span", { className: "wallet-Transaction-recipitentBox-adddressBox-address" }, recip.address))),
                                    react_1.default.createElement("section", { style: { marginLeft: '20px' } },
                                        react_1.default.createElement("article", { className: "wallet-Transaction-recipitentBox-transactionFee-header" }, window.i18n('transactionFee')),
                                        react_1.default.createElement("article", { className: "wallet-Transaction-recipitentBox-transactionFee-text" },
                                            item.fee / 1e9,
                                            " BDX")),
                                    item.payment_id != '0000000000000000' && (react_1.default.createElement("section", { style: { marginLeft: '20px' } },
                                        react_1.default.createElement("article", { className: "wallet-Transaction-recipitentBox-transactionFee-header" }, window.i18n('paymentID')),
                                        react_1.default.createElement("article", { className: "wallet-Transaction-recipitentBox-transactionFee-text" }, item.payment_id)))))))))),
                !syncStatus && (react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center", height: "100%" },
                    react_1.default.createElement("div", { className: "wallet-syncing" },
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'rotatedArrow', iconSize: 70, iconColor: darkMode ? '#65656E' : '#ACACAC' }),
                        ' '),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement("h3", { className: "wallet-syncing-title" }, "Wallet Syncing.."),
                    react_1.default.createElement(Text_1.SpacerXS, null),
                    react_1.default.createElement("h5", { className: "wallet-syncing-content" }, window.i18n('walletSyncingDiscription')))),
                syncStatus && data.length == 0 ? (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement("div", { className: "wallet-Transaction-empty-parentBox" },
                        react_1.default.createElement("div", { className: `wallet-Transaction-${emptyScreen.toLocaleLowerCase()}` }),
                        react_1.default.createElement("div", { style: { marginTop: '5px' } }, emptyScreen == 'All' ? (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement("div", { className: "wallet-Transaction-content" }, window.i18n('emptyTransaction')),
                            !searchText && (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { margin: 'auto', marginTop: '5px', width: '223px' } }, window.i18n('emptyTransactionDiscription'))))) : emptyScreen == 'imcoming' ? (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { marginTop: '0px' } }, window.i18n('noIncomingTransaction'))) : emptyScreen == 'search' ? (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { marginTop: '0px' } }, window.i18n('searchEmptyTransaction'))) : emptyScreen == 'Outgoing' ? (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { marginTop: '0px' } }, window.i18n('noOutgoingTransaction'))) : emptyScreen == 'Pending' ? (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { marginTop: '0px' } }, window.i18n('noPendingTransaction'))) : (react_1.default.createElement("h5", { className: "wallet-Transaction-subContent", style: { marginTop: '0px' } }, window.i18n('noFailedTransaction'))))))) : ('')),
            zoomLevel > 100 && react_1.default.createElement(Text_1.SpacerLG, null))));
};
exports.TransactionSection = TransactionSection;
