"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeItemById = exports.getAllItems = exports.getItemById = exports.createOrUpdateItem = void 0;
const lodash_1 = __importDefault(require("lodash"));
const String_1 = require("../bchat/utils/String");
const channels_1 = require("./channels");
function keysToArrayBuffer(keys, data) {
    const updated = lodash_1.default.cloneDeep(data);
    for (let i = 0, max = keys.length; i < max; i += 1) {
        const key = keys[i];
        const value = lodash_1.default.get(data, key);
        if (value) {
            lodash_1.default.set(updated, key, (0, String_1.fromBase64ToArrayBuffer)(value));
        }
    }
    return updated;
}
function keysFromArrayBuffer(keys, data) {
    const updated = lodash_1.default.cloneDeep(data);
    for (let i = 0, max = keys.length; i < max; i += 1) {
        const key = keys[i];
        const value = lodash_1.default.get(data, key);
        if (value) {
            lodash_1.default.set(updated, key, (0, String_1.fromArrayBufferToBase64)(value));
        }
    }
    return updated;
}
const ITEM_KEYS = {
    identityKey: ['value.pubKey', 'value.privKey'],
    profileKey: ['value'],
};
async function createOrUpdateItem(data) {
    const { id } = data;
    if (!id) {
        throw new Error('createOrUpdateItem: Provided data did not have a truthy id');
    }
    const keys = ITEM_KEYS[id];
    const updated = Array.isArray(keys) ? keysFromArrayBuffer(keys, data) : data;
    await channels_1.channels.createOrUpdateItem(updated);
}
exports.createOrUpdateItem = createOrUpdateItem;
async function getItemById(id) {
    const keys = ITEM_KEYS[id];
    const data = await channels_1.channels.getItemById(id);
    return Array.isArray(keys) ? keysToArrayBuffer(keys, data) : data;
}
exports.getItemById = getItemById;
async function getAllItems() {
    const items = await channels_1.channels.getAllItems();
    return lodash_1.default.map(items, item => {
        const { id } = item;
        const keys = ITEM_KEYS[id];
        return Array.isArray(keys) ? keysToArrayBuffer(keys, item) : item;
    });
}
exports.getAllItems = getAllItems;
async function removeItemById(id) {
    await channels_1.channels.removeItemById(id);
}
exports.removeItemById = removeItemById;
