"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllOpenGroupV2Conversations = exports.removeV2OpenGroupRoom = exports.saveV2OpenGroupRoom = exports.getV2OpenGroupRoomByRoomId = exports.getV2OpenGroupRoom = exports.getAllV2OpenGroupRooms = exports.OpenGroupData = void 0;
const conversation_1 = require("../models/conversation");
const OpenGroupUtils_1 = require("../bchat/apis/open_group_api/utils/OpenGroupUtils");
const channels_1 = require("./channels");
exports.OpenGroupData = {
    getV2OpenGroupRoom,
    opengroupRoomsLoad,
    saveV2OpenGroupRoom,
    getV2OpenGroupRoomByRoomId,
    removeV2OpenGroupRoom,
    getAllV2OpenGroupRooms,
};
async function getAllV2OpenGroupRooms() {
    const opengroupsv2Rooms = (await channels_1.channels.getAllV2OpenGroupRooms());
    if (!opengroupsv2Rooms) {
        return undefined;
    }
    const results = new Map();
    opengroupsv2Rooms.forEach(o => {
        if (o.conversationId) {
            results.set(o.conversationId, o);
        }
    });
    return results;
}
exports.getAllV2OpenGroupRooms = getAllV2OpenGroupRooms;
let cachedRooms = null;
async function opengroupRoomsLoad() {
    if (cachedRooms !== null) {
        return;
    }
    const loadedFromDB = (await exports.OpenGroupData.getAllV2OpenGroupRooms());
    if (loadedFromDB) {
        cachedRooms = new Array();
        loadedFromDB.forEach(r => {
            try {
                cachedRooms?.push(r);
            }
            catch (e) {
                window.log.warn(e.message);
            }
        });
        return;
    }
    cachedRooms = [];
}
async function getV2OpenGroupRoom(conversationId) {
    if (!(0, OpenGroupUtils_1.isOpenGroupV2)(conversationId)) {
        throw new Error(`getV2OpenGroupRoom: this is not a valid v2 id: ${conversationId}`);
    }
    const opengroupv2Rooms = await channels_1.channels.getV2OpenGroupRoom(conversationId);
    if (!opengroupv2Rooms) {
        return undefined;
    }
    return opengroupv2Rooms;
}
exports.getV2OpenGroupRoom = getV2OpenGroupRoom;
async function getV2OpenGroupRoomByRoomId(roomInfos) {
    const room = await channels_1.channels.getV2OpenGroupRoomByRoomId(roomInfos.serverUrl, roomInfos.roomId);
    if (!room) {
        return undefined;
    }
    return room;
}
exports.getV2OpenGroupRoomByRoomId = getV2OpenGroupRoomByRoomId;
async function saveV2OpenGroupRoom(opengroupsv2Room) {
    if (!opengroupsv2Room.conversationId ||
        !opengroupsv2Room.roomId ||
        !opengroupsv2Room.serverUrl ||
        !opengroupsv2Room.serverPublicKey) {
        throw new Error('Cannot save v2 room, invalid data');
    }
    await channels_1.channels.saveV2OpenGroupRoom(opengroupsv2Room);
}
exports.saveV2OpenGroupRoom = saveV2OpenGroupRoom;
async function removeV2OpenGroupRoom(conversationId) {
    await channels_1.channels.removeV2OpenGroupRoom(conversationId);
}
exports.removeV2OpenGroupRoom = removeV2OpenGroupRoom;
async function getAllOpenGroupV2Conversations() {
    const conversations = await channels_1.channels.getAllOpenGroupV2Conversations();
    const collection = new conversation_1.ConversationCollection();
    collection.add(conversations);
    return collection;
}
exports.getAllOpenGroupV2Conversations = getAllOpenGroupV2Conversations;
