"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useAppIsFocused = void 0;
const react_1 = require("react");
const react_redux_1 = require("react-redux");
const section_1 = require("../state/ducks/section");
const section_2 = require("../state/selectors/section");
const electron_1 = require("electron");
function useAppIsFocused() {
    const dispatch = (0, react_redux_1.useDispatch)();
    const isFocusedFromStore = (0, react_redux_1.useSelector)(section_2.getIsAppFocused);
    const ipcCallback = (_event, isFocused) => {
        if (isFocusedFromStore !== isFocused) {
            dispatch((0, section_1.setIsAppFocused)(Boolean(isFocused)));
        }
    };
    (0, react_1.useEffect)(() => {
        electron_1.ipcRenderer.on('set-window-focus', ipcCallback);
        return () => {
            electron_1.ipcRenderer.removeListener('set-window-focus', ipcCallback);
        };
    });
    return isFocusedFromStore;
}
exports.useAppIsFocused = useAppIsFocused;
