"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useEncryptedFileFetch = void 0;
const react_1 = require("react");
const DecryptedAttachmentsManager_1 = require("../bchat/crypto/DecryptedAttachmentsManager");
const Performance_1 = require("../bchat/utils/Performance");
const useEncryptedFileFetch = (url, contentType, isAvatar) => {
    const [urlToLoad, setUrlToLoad] = (0, react_1.useState)('');
    const [loading, setLoading] = (0, react_1.useState)(false);
    const mountedRef = (0, react_1.useRef)(true);
    async function fetchUrl() {
        (0, Performance_1.perfStart)(`getDecryptedMediaUrl-${url}`);
        const decryptedUrl = await (0, DecryptedAttachmentsManager_1.getDecryptedMediaUrl)(url, contentType, isAvatar);
        (0, Performance_1.perfEnd)(`getDecryptedMediaUrl-${url}`, `getDecryptedMediaUrl-${url}`);
        if (mountedRef.current) {
            setUrlToLoad(decryptedUrl);
            setLoading(false);
        }
    }
    const alreadyDecrypted = (0, DecryptedAttachmentsManager_1.getAlreadyDecryptedMediaUrl)(url);
    (0, react_1.useEffect)(() => {
        if (alreadyDecrypted) {
            return;
        }
        setLoading(true);
        mountedRef.current = true;
        void fetchUrl();
        return () => {
            mountedRef.current = false;
        };
    }, [url]);
    if (alreadyDecrypted) {
        return { urlToLoad: alreadyDecrypted, loading: false };
    }
    return { urlToLoad, loading };
};
exports.useEncryptedFileFetch = useEncryptedFileFetch;
