"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useMembersAvatars = void 0;
const utils_1 = require("../bchat/utils");
const _ = __importStar(require("lodash"));
const react_redux_1 = require("react-redux");
function useMembersAvatars(closedGroupPubkey) {
    const ourPrimary = utils_1.UserUtils.getOurPubKeyStrFromCache();
    return (0, react_redux_1.useSelector)((state) => {
        if (!closedGroupPubkey) {
            return undefined;
        }
        const groupConvo = state.conversations.conversationLookup[closedGroupPubkey];
        if (groupConvo.isPrivate || groupConvo.isPublic || !groupConvo.isGroup) {
            return undefined;
        }
        const originalMembers = _.cloneDeep(groupConvo.members);
        if (!originalMembers || originalMembers.length === 0) {
            return undefined;
        }
        const allMembersSorted = originalMembers.sort((a, b) => (a < b ? -1 : a > b ? 1 : 0));
        const usAtTheEndMaxTwo = _.sortBy(allMembersSorted, a => (a === ourPrimary ? 1 : 0)).slice(0, 2);
        const memberConvos = _.compact(usAtTheEndMaxTwo
            .map(m => state.conversations.conversationLookup[m])
            .map(m => {
            return m?.id || undefined;
        }));
        return memberConvos && memberConvos.length ? memberConvos : undefined;
    });
}
exports.useMembersAvatars = useMembersAvatars;
