"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.callRecipient = exports.showLinkSharingConfirmationModalDialog = exports.replyToMessage = exports.uploadOurAvatar = exports.setDisappearingMessagesByConvoId = exports.deleteAllMessagesByConvoIdWithConfirmation = exports.deleteAllMessagesByConvoIdNoConfirmation = exports.showChangeNickNameByConvoId = exports.clearNickNameByConvoId = exports.setNotificationForConvoId = exports.markAllReadByConvoId = exports.showUnbanUserByConvoId = exports.showBanUserByConvoId = exports.showRemoveModeratorsByConvoId = exports.showAddModeratorsByConvoId = exports.onMarkAllReadByConvoId = exports.showInviteContactByConvoId = exports.deleteGroupByConvoId = exports.showLeaveGroupByConvoId = exports.showUpdateGroupMembersByConvoId = exports.showUpdateGroupNameByConvoId = exports.declineConversationWithoutConfirm = exports.declineConversationWithConfirm = exports.approveConvoAndSendResponse = exports.unblockConvoById = exports.blockConvoById = exports.copyPublicKeyByConvoId = exports.getCompleteUrlForV2ConvoId = void 0;
const OpenGroupUtils_1 = require("../bchat/apis/open_group_api/utils/OpenGroupUtils");
const opengroups_1 = require("../data/opengroups");
const utils_1 = require("../bchat/utils");
const conversation_1 = require("../models/conversation");
const conversations_1 = require("../bchat/conversations");
const blockedNumberController_1 = require("../util/blockedNumberController");
const modalDialog_1 = require("../state/ducks/modalDialog");
const data_1 = require("../data/data");
const conversations_2 = require("../state/ducks/conversations");
const DecryptedAttachmentsManager_1 = require("../bchat/crypto/DecryptedAttachmentsManager");
const MIME_1 = require("../types/MIME");
const file_server_api_1 = require("../bchat/apis/file_server_api");
const String_1 = require("../bchat/utils/String");
const syncUtils_1 = require("../bchat/utils/syncUtils");
const BchatButton_1 = require("../components/basic/BchatButton");
const BchatSettings_1 = require("../components/settings/BchatSettings");
const Performance_1 = require("../bchat/utils/Performance");
const MessageAttachment_1 = require("../types/MessageAttachment");
const VisualAttachment_1 = require("../types/attachments/VisualAttachment");
const types_1 = require("../types");
const storage_1 = require("../util/storage");
const crypto_1 = require("../bchat/crypto");
const profileEncrypter_1 = require("../util/crypto/profileEncrypter");
const getCompleteUrlForV2ConvoId = async (convoId) => {
    if (convoId.match(OpenGroupUtils_1.openGroupV2ConversationIdRegex)) {
        const roomInfos = await (0, opengroups_1.getV2OpenGroupRoom)(convoId);
        if (roomInfos) {
            const fullUrl = (0, OpenGroupUtils_1.getCompleteUrlFromRoom)(roomInfos);
            return fullUrl;
        }
    }
    return undefined;
};
exports.getCompleteUrlForV2ConvoId = getCompleteUrlForV2ConvoId;
async function copyPublicKeyByConvoId(convoId) {
    if (convoId.match(OpenGroupUtils_1.openGroupPrefixRegex)) {
        if (convoId.match(OpenGroupUtils_1.openGroupV2ConversationIdRegex)) {
            const completeUrl = await (0, exports.getCompleteUrlForV2ConvoId)(convoId);
            if (completeUrl) {
                window.clipboard.writeText(completeUrl);
                utils_1.ToastUtils.pushCopiedToClipBoard();
                return;
            }
            window?.log?.warn('copy to pubkey no roomInfo');
            return;
        }
        const atIndex = convoId.indexOf('@');
        const openGroupUrl = convoId.substr(atIndex + 1);
        window.clipboard.writeText(openGroupUrl);
        utils_1.ToastUtils.pushCopiedToClipBoard();
        return;
    }
    window.clipboard.writeText(convoId);
    utils_1.ToastUtils.pushCopiedToClipBoard();
}
exports.copyPublicKeyByConvoId = copyPublicKeyByConvoId;
async function blockConvoById(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (!conversation.id || conversation.isPublic()) {
        return;
    }
    const promise = conversation.isPrivate()
        ? blockedNumberController_1.BlockedNumberController.block(conversation.id)
        : blockedNumberController_1.BlockedNumberController.blockGroup(conversation.id);
    await promise;
    await conversation.commit();
    utils_1.ToastUtils.pushToastSuccess('blocked', window.i18n('blocked'));
}
exports.blockConvoById = blockConvoById;
async function unblockConvoById(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (!conversation) {
        await blockedNumberController_1.BlockedNumberController.unblock(conversationId);
        utils_1.ToastUtils.pushToastSuccess('unblocked', window.i18n('unblocked'));
        return;
    }
    if (!conversation.id || conversation.isPublic()) {
        return;
    }
    const promise = conversation.isPrivate()
        ? blockedNumberController_1.BlockedNumberController.unblock(conversationId)
        : blockedNumberController_1.BlockedNumberController.unblockGroup(conversationId);
    await promise;
    utils_1.ToastUtils.pushToastSuccess('unblocked', window.i18n('unblocked'));
    await conversation.commit();
}
exports.unblockConvoById = unblockConvoById;
const approveConvoAndSendResponse = async (conversationId, syncToDevices = true) => {
    const convoToApprove = (0, conversations_1.getConversationController)().get(conversationId);
    if (!convoToApprove || convoToApprove.isApproved()) {
        window?.log?.info('Conversation is already approved.');
        return;
    }
    await convoToApprove.setIsApproved(true, false);
    await convoToApprove.commit();
    await convoToApprove.sendMessageRequestResponse(true);
    if (syncToDevices) {
        await (0, syncUtils_1.forceSyncConfigurationNowIfNeeded)();
    }
};
exports.approveConvoAndSendResponse = approveConvoAndSendResponse;
const declineConversationWithConfirm = (convoId, syncToDevices = true, customIcon) => {
    window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
        title: 'Decline Request?',
        okText: window.i18n('decline'),
        okTheme: BchatButton_1.BchatButtonColor.Red,
        cancelText: window.i18n('cancel'),
        message: window.i18n('declineRequestMessage'),
        iconShow: true,
        customIcon: customIcon,
        onClickOk: async () => {
            await (0, exports.declineConversationWithoutConfirm)(convoId, syncToDevices);
            await blockConvoById(convoId);
            await (0, syncUtils_1.forceSyncConfigurationNowIfNeeded)();
            window?.inboxStore?.dispatch((0, conversations_2.resetConversationExternal)());
        },
        onClickCancel: () => {
            window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        },
        onClickClose: () => {
            window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        },
    }));
};
exports.declineConversationWithConfirm = declineConversationWithConfirm;
const declineConversationWithoutConfirm = async (conversationId, syncToDevices = true) => {
    const conversationToDecline = (0, conversations_1.getConversationController)().get(conversationId);
    if (!conversationToDecline || conversationToDecline.isApproved()) {
        window?.log?.info('Conversation is already declined.');
        return;
    }
    await conversationToDecline.setIsApproved(false);
    if (syncToDevices) {
        await (0, syncUtils_1.forceSyncConfigurationNowIfNeeded)();
    }
};
exports.declineConversationWithoutConfirm = declineConversationWithoutConfirm;
async function showUpdateGroupNameByConvoId(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (conversation.isMediumGroup()) {
        await Promise.all(conversation
            .get('members')
            .map(m => (0, conversations_1.getConversationController)().getOrCreateAndWait(m, conversation_1.ConversationTypeEnum.PRIVATE)));
    }
    window.inboxStore?.dispatch((0, modalDialog_1.updateGroupNameModal)({ conversationId }));
}
exports.showUpdateGroupNameByConvoId = showUpdateGroupNameByConvoId;
async function showUpdateGroupMembersByConvoId(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (conversation.isMediumGroup()) {
        await Promise.all(conversation
            .get('members')
            .map(m => (0, conversations_1.getConversationController)().getOrCreateAndWait(m, conversation_1.ConversationTypeEnum.PRIVATE)));
    }
    window.inboxStore?.dispatch((0, modalDialog_1.updateGroupMembersModal)({ conversationId }));
}
exports.showUpdateGroupMembersByConvoId = showUpdateGroupMembersByConvoId;
function showLeaveGroupByConvoId(conversationId, username, customIcon) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (!conversation.isGroup()) {
        throw new Error('showLeaveGroupDialog() called with a non group convo.');
    }
    const title = window.i18n('leaveGroup');
    const message = window.i18n('leaveGroupConfirmation', [username]);
    const ourPK = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const isAdmin = (conversation.get('groupAdmins') || []).includes(ourPK);
    const isClosedGroup = conversation.get('is_medium_group') || false;
    if (!isClosedGroup || (isClosedGroup && !isAdmin)) {
        const onClickClose = () => {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        };
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            title,
            message,
            onClickOk: async () => {
                await conversation.leaveClosedGroup();
                onClickClose();
            },
            onClickClose,
            okTheme: BchatButton_1.BchatButtonColor.Danger,
            iconShow: true,
            customIcon
        }));
    }
    else {
        window.inboxStore?.dispatch((0, modalDialog_1.adminLeaveClosedGroup)({
            conversationId,
        }));
    }
}
exports.showLeaveGroupByConvoId = showLeaveGroupByConvoId;
function deleteGroupByConvoId(conversationId, username) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    if (!conversation.isGroup()) {
        throw new Error('showLeaveGroupDialog() called with a non group convo.');
    }
    const title = window.i18n('editMenuDeleteGroup');
    const deletetxt = window.i18n('delete');
    const message = `Are you sure you want to delete this group,${username}?`;
    const ourPK = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const isAdmin = (conversation.get('groupAdmins') || []).includes(ourPK);
    const isClosedGroup = conversation.get('is_medium_group') || false;
    if (!isClosedGroup || (isClosedGroup && !isAdmin)) {
        const onClickClose = () => {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        };
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            title,
            message,
            onClickOk: async () => {
                await (0, conversations_1.getConversationController)().deleteContact(conversationId);
                ;
                onClickClose();
            },
            onClickClose,
            okText: deletetxt,
            okTheme: BchatButton_1.BchatButtonColor.Danger,
        }));
    }
    else {
        window.inboxStore?.dispatch((0, modalDialog_1.adminLeaveClosedGroup)({
            conversationId,
        }));
    }
}
exports.deleteGroupByConvoId = deleteGroupByConvoId;
function showInviteContactByConvoId(conversationId) {
    window.inboxStore?.dispatch((0, modalDialog_1.updateInviteContactModal)({ conversationId }));
}
exports.showInviteContactByConvoId = showInviteContactByConvoId;
async function onMarkAllReadByConvoId(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    await conversation.markReadBouncy(Date.now());
}
exports.onMarkAllReadByConvoId = onMarkAllReadByConvoId;
function showAddModeratorsByConvoId(conversationId) {
    window.inboxStore?.dispatch((0, modalDialog_1.updateAddModeratorsModal)({ conversationId }));
}
exports.showAddModeratorsByConvoId = showAddModeratorsByConvoId;
function showRemoveModeratorsByConvoId(conversationId) {
    window.inboxStore?.dispatch((0, modalDialog_1.updateRemoveModeratorsModal)({ conversationId }));
}
exports.showRemoveModeratorsByConvoId = showRemoveModeratorsByConvoId;
function showBanUserByConvoId(conversationId, pubkey) {
    window.inboxStore?.dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)({ banType: 'ban', conversationId, pubkey }));
}
exports.showBanUserByConvoId = showBanUserByConvoId;
function showUnbanUserByConvoId(conversationId, pubkey) {
    window.inboxStore?.dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)({ banType: 'unban', conversationId, pubkey }));
}
exports.showUnbanUserByConvoId = showUnbanUserByConvoId;
async function markAllReadByConvoId(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    (0, Performance_1.perfStart)(`markAllReadByConvoId-${conversationId}`);
    await conversation.markReadBouncy(Date.now());
    (0, Performance_1.perfEnd)(`markAllReadByConvoId-${conversationId}`, 'markAllReadByConvoId');
}
exports.markAllReadByConvoId = markAllReadByConvoId;
async function setNotificationForConvoId(conversationId, selected) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    const existingSettings = conversation.get('triggerNotificationsFor');
    if (existingSettings !== selected) {
        conversation.set({ triggerNotificationsFor: selected });
        await conversation.commit();
    }
}
exports.setNotificationForConvoId = setNotificationForConvoId;
async function clearNickNameByConvoId(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    await conversation.setNickname(undefined);
}
exports.clearNickNameByConvoId = clearNickNameByConvoId;
function showChangeNickNameByConvoId(conversationId) {
    window.inboxStore?.dispatch((0, modalDialog_1.changeNickNameModal)({ conversationId }));
}
exports.showChangeNickNameByConvoId = showChangeNickNameByConvoId;
async function deleteAllMessagesByConvoIdNoConfirmation(conversationId) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    window.inboxStore?.dispatch((0, conversations_2.conversationReset)(conversationId));
    conversation.set({
        lastMessage: null,
        unreadCount: 0,
    });
    await conversation.commit();
    await (0, data_1.removeAllMessagesInConversation)(conversationId);
}
exports.deleteAllMessagesByConvoIdNoConfirmation = deleteAllMessagesByConvoIdNoConfirmation;
function deleteAllMessagesByConvoIdWithConfirmation(conversationId) {
    const onClickClose = () => {
        window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
    };
    const onClickOk = async () => {
        await deleteAllMessagesByConvoIdNoConfirmation(conversationId);
        onClickClose();
    };
    window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
        title: window.i18n('deleteMessages'),
        message: window.i18n('deleteConversationConfirmation'),
        onClickOk,
        okTheme: BchatButton_1.BchatButtonColor.Danger,
        onClickClose,
        okText: window.i18n('delete')
    }));
}
exports.deleteAllMessagesByConvoIdWithConfirmation = deleteAllMessagesByConvoIdWithConfirmation;
async function setDisappearingMessagesByConvoId(conversationId, seconds) {
    const conversation = (0, conversations_1.getConversationController)().get(conversationId);
    const canSetDisappearing = !conversation.isOutgoingRequest() && !conversation.isIncomingRequest();
    if (!canSetDisappearing) {
        utils_1.ToastUtils.pushMustBeApproved();
        return;
    }
    if (!seconds || seconds <= 0) {
        await conversation.updateExpireTimer(null);
    }
    else {
        await conversation.updateExpireTimer(seconds);
    }
}
exports.setDisappearingMessagesByConvoId = setDisappearingMessagesByConvoId;
async function uploadOurAvatar(newAvatarDecrypted) {
    const ourConvo = (0, conversations_1.getConversationController)().get(utils_1.UserUtils.getOurPubKeyStrFromCache());
    if (!ourConvo) {
        window.log.warn('ourConvo not found... This is not a valid case');
        return;
    }
    let profileKey;
    let decryptedAvatarData;
    if (newAvatarDecrypted) {
        profileKey = (await (0, crypto_1.getSodiumRenderer)()).randombytes_buf(32);
        decryptedAvatarData = newAvatarDecrypted;
    }
    else {
        const ourConvoProfileKey = (0, conversations_1.getConversationController)()
            .get(utils_1.UserUtils.getOurPubKeyStrFromCache())
            ?.get('profileKey') || null;
        profileKey = ourConvoProfileKey ? (0, String_1.fromHexToArray)(ourConvoProfileKey) : null;
        if (!profileKey) {
            window.log.info('our profileKey not found. Not reuploading our avatar');
            return;
        }
        const currentAttachmentPath = ourConvo.getAvatarPath();
        if (!currentAttachmentPath) {
            window.log.warn('No attachment currently set for our convo.. Nothing to do.');
            return;
        }
        const decryptedAvatarUrl = await (0, DecryptedAttachmentsManager_1.getDecryptedMediaUrl)(currentAttachmentPath, MIME_1.IMAGE_JPEG, true);
        if (!decryptedAvatarUrl) {
            window.log.warn('Could not decrypt avatar stored locally..');
            return;
        }
        const blob = await (0, VisualAttachment_1.urlToBlob)(decryptedAvatarUrl);
        decryptedAvatarData = await blob.arrayBuffer();
    }
    if (!decryptedAvatarData?.byteLength) {
        window.log.warn('Could not read content of avatar ...');
        return;
    }
    const encryptedData = await (0, profileEncrypter_1.encryptProfile)(decryptedAvatarData, profileKey);
    const avatarPointer = await file_server_api_1.FSv2.uploadFileToFsV2(encryptedData);
    let fileUrl;
    if (!avatarPointer) {
        window.log.warn('failed to upload avatar to fsv2');
        return;
    }
    ({ fileUrl } = avatarPointer);
    ourConvo.set('avatarPointer', fileUrl);
    const upgraded = await (0, MessageAttachment_1.processNewAttachment)({
        isRaw: true,
        data: decryptedAvatarData,
        contentType: types_1.MIME.IMAGE_UNKNOWN,
    });
    ourConvo.set('avatar', null);
    const displayName = ourConvo.get('profileName');
    ourConvo.set({ profileKey: (0, String_1.toHex)(profileKey) });
    await ourConvo.setBchatProfile({
        avatar: upgraded.path,
        displayName,
    });
    const newTimestampReupload = Date.now();
    await (0, data_1.createOrUpdateItem)({ id: data_1.lastAvatarUploadTimestamp, value: newTimestampReupload });
    if (newAvatarDecrypted) {
        await (0, storage_1.setLastProfileUpdateTimestamp)(Date.now());
        await utils_1.SyncUtils.forceSyncConfigurationNowIfNeeded(true);
    }
    else {
        window.log.info(`Reuploading avatar finished at ${newTimestampReupload}, newAttachmentPointer ${fileUrl}`);
    }
}
exports.uploadOurAvatar = uploadOurAvatar;
async function replyToMessage(messageId) {
    const quotedMessageModel = await (0, data_1.getMessageById)(messageId);
    if (!quotedMessageModel) {
        window.log.warn('Failed to find message to reply to');
        return;
    }
    const conversationModel = (0, conversations_1.getConversationController)().getOrThrow(quotedMessageModel.get('conversationId'));
    const quotedMessageProps = await conversationModel.makeQuote(quotedMessageModel);
    if (quotedMessageProps) {
        window.inboxStore?.dispatch((0, conversations_2.quoteMessage)(quotedMessageProps));
    }
    else {
        window.inboxStore?.dispatch((0, conversations_2.quoteMessage)(undefined));
    }
}
exports.replyToMessage = replyToMessage;
async function showLinkSharingConfirmationModalDialog(e) {
    const pastedText = e.clipboardData.getData('text');
    if (isURL(pastedText) && !window.getSettingValue('link-preview-setting', false)) {
        const alreadyDisplayedPopup = (await (0, data_1.getItemById)(data_1.hasLinkPreviewPopupBeenDisplayed))?.value || false;
        if (!alreadyDisplayedPopup) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
                shouldShowConfirm: !window.getSettingValue('link-preview-setting') && !alreadyDisplayedPopup,
                title: window.i18n('linkPreviewsTitle'),
                message: window.i18n('linkPreviewsConfirmMessage'),
                okTheme: BchatButton_1.BchatButtonColor.Danger,
                onClickOk: () => {
                    window.setSettingValue('link-preview-setting', true);
                },
                onClickClose: async () => {
                    await (0, data_1.createOrUpdateItem)({ id: data_1.hasLinkPreviewPopupBeenDisplayed, value: true });
                },
            }));
        }
    }
}
exports.showLinkSharingConfirmationModalDialog = showLinkSharingConfirmationModalDialog;
function isURL(str) {
    const urlRegex = '^(?!mailto:)(?:(?:http|https|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[0-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))|localhost)(?::\\d{2,5})?(?:(/|\\?|#)[^\\s]*)?$';
    const url = new RegExp(urlRegex, 'i');
    return str.length < 2083 && url.test(str);
}
async function callRecipient(pubkey, canCall) {
    const convo = (0, conversations_1.getConversationController)().get(pubkey);
    if (!canCall) {
        utils_1.ToastUtils.pushUnableToCall();
        return;
    }
    if (!(0, BchatSettings_1.getCallMediaPermissionsSettings)()) {
        utils_1.ToastUtils.pushVideoCallPermissionNeeded();
        return;
    }
    if (convo && convo.isPrivate() && !convo.isMe()) {
        await utils_1.CallManager.USER_callRecipient(convo.id);
    }
}
exports.callRecipient = callRecipient;
