"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.acceptOpenGroupInvitation = exports.addSenderAsModerator = exports.removeSenderFromModerator = exports.copyBodyToClipboard = exports.unbanUser = exports.banUser = void 0;
const opengroupV2_1 = require("../bchat/apis/open_group_api/opengroupV2");
const JoinOpenGroupV2_1 = require("../bchat/apis/open_group_api/opengroupV2/JoinOpenGroupV2");
const OpenGroupUtils_1 = require("../bchat/apis/open_group_api/utils/OpenGroupUtils");
const conversations_1 = require("../bchat/conversations");
const types_1 = require("../bchat/types");
const BchatButton_1 = require("../components/basic/BchatButton");
const modalDialog_1 = require("../state/ducks/modalDialog");
const utils_1 = require("../bchat/utils");
function banUser(userToBan, conversationId) {
    let pubKeyToBan;
    try {
        pubKeyToBan = types_1.PubKey.cast(userToBan);
    }
    catch (e) {
        window?.log?.warn(e);
        utils_1.ToastUtils.pushUserBanFailure();
        return;
    }
    if (!(0, OpenGroupUtils_1.isOpenGroupV2)(conversationId)) {
        window.log.warn(`Conversation ${conversationId} is not an Social group`);
        utils_1.ToastUtils.pushUserBanFailure();
        return;
    }
    window.inboxStore?.dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)({ banType: 'ban', conversationId, pubkey: pubKeyToBan.key }));
}
exports.banUser = banUser;
function unbanUser(userToUnBan, conversationId) {
    let pubKeyToUnban;
    try {
        pubKeyToUnban = types_1.PubKey.cast(userToUnBan);
    }
    catch (e) {
        window?.log?.warn(e);
        utils_1.ToastUtils.pushUserBanFailure();
        return;
    }
    if (!(0, OpenGroupUtils_1.isOpenGroupV2)(conversationId)) {
        window.log.warn(`Conversation ${conversationId} is not an Social group`);
        utils_1.ToastUtils.pushUserUnbanFailure();
        return;
    }
    window.inboxStore?.dispatch((0, modalDialog_1.updateBanOrUnbanUserModal)({ banType: 'unban', conversationId, pubkey: pubKeyToUnban.key }));
}
exports.unbanUser = unbanUser;
function copyBodyToClipboard(body) {
    window.clipboard.writeText(body);
    utils_1.ToastUtils.pushCopiedToClipBoard();
}
exports.copyBodyToClipboard = copyBodyToClipboard;
async function removeSenderFromModerator(sender, convoId) {
    try {
        const pubKeyToRemove = types_1.PubKey.cast(sender);
        const convo = (0, conversations_1.getConversationController)().getOrThrow(convoId);
        const roomInfo = convo.toOpenGroupV2();
        const res = await opengroupV2_1.ApiV2.removeModerator(pubKeyToRemove, roomInfo);
        if (!res) {
            window?.log?.warn('failed to remove moderator:', res);
            utils_1.ToastUtils.pushFailedToRemoveFromModerator();
        }
        else {
            window?.log?.info(`${pubKeyToRemove.key} removed from moderators...`);
            utils_1.ToastUtils.pushUserRemovedFromModerators();
        }
    }
    catch (e) {
        window?.log?.error('Got error while removing moderator:', e);
    }
}
exports.removeSenderFromModerator = removeSenderFromModerator;
async function addSenderAsModerator(sender, convoId) {
    try {
        const pubKeyToAdd = types_1.PubKey.cast(sender);
        const convo = (0, conversations_1.getConversationController)().getOrThrow(convoId);
        const roomInfo = convo.toOpenGroupV2();
        const res = await opengroupV2_1.ApiV2.addModerator(pubKeyToAdd, roomInfo);
        if (!res) {
            window?.log?.warn('failed to add moderator:', res);
            utils_1.ToastUtils.pushFailedToAddAsModerator();
        }
        else {
            window?.log?.info(`${pubKeyToAdd.key} added to moderators...`);
            utils_1.ToastUtils.pushUserAddedToModerators();
        }
    }
    catch (e) {
        window?.log?.error('Got error while adding moderator:', e);
    }
}
exports.addSenderAsModerator = addSenderAsModerator;
const acceptSocialGroupInvitationV2 = (completeUrl, roomName) => {
    const onClickClose = () => {
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
    };
    window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
        title: window.i18n('joinSocialGroupAfterInvitationConfirmationTitle', [
            roomName || 'Unknown',
        ]),
        message: window.i18n('joinSocialGroupAfterInvitationConfirmationDesc', [
            roomName || 'Unknown',
        ]),
        okText: 'Yes',
        okTheme: BchatButton_1.BchatButtonColor.Primary,
        cancelText: 'No',
        iconShow: true,
        iconSize: 30,
        bchatIcon: 'peopleGrp',
        onClickOk: async () => {
            await (0, JoinOpenGroupV2_1.joinOpenGroupV2WithUIEvents)(completeUrl, true, false);
        },
        onClickClose,
    }));
};
const acceptOpenGroupInvitation = (completeUrl, roomName) => {
    if (completeUrl.match(OpenGroupUtils_1.openGroupV2CompleteURLRegex)) {
        acceptSocialGroupInvitationV2(completeUrl, roomName);
    }
    else {
        window?.log?.warn('Invalid opengroup url:', completeUrl);
    }
};
exports.acceptOpenGroupInvitation = acceptOpenGroupInvitation;
