"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageCollection = exports.sliceQuoteText = exports.MessageModel = exports.arrayContainsOneItemOnly = exports.arrayContainsUsOnly = void 0;
const backbone_1 = __importDefault(require("backbone"));
const filesize_1 = __importDefault(require("filesize"));
const protobuf_1 = require("../../ts/protobuf");
const bchat_1 = require("../bchat");
const conversations_1 = require("../bchat/conversations");
const outgoing_1 = require("../bchat/messages/outgoing");
const ClosedGroupVisibleMessage_1 = require("../bchat/messages/outgoing/visibleMessage/ClosedGroupVisibleMessage");
const types_1 = require("../bchat/types");
const utils_1 = require("../bchat/utils");
const messageType_1 = require("./messageType");
const auto_bind_1 = __importDefault(require("auto-bind"));
const data_1 = require("../../ts/data/data");
const conversation_1 = require("./conversation");
const conversations_2 = require("../state/ducks/conversations");
const VisibleMessage_1 = require("../bchat/messages/outgoing/visibleMessage/VisibleMessage");
const syncUtils_1 = require("../bchat/utils/syncUtils");
const AttachmentsV2_1 = require("../bchat/utils/AttachmentsV2");
const OpenGroupVisibleMessage_1 = require("../bchat/messages/outgoing/visibleMessage/OpenGroupVisibleMessage");
const opengroups_1 = require("../data/opengroups");
const User_1 = require("../bchat/utils/User");
const Performance_1 = require("../bchat/utils/Performance");
const Attachment_1 = require("../types/Attachment");
const lodash_1 = __importStar(require("lodash"));
const settings_key_1 = require("../data/settings-key");
const MessageAttachment_1 = require("../types/MessageAttachment");
const expiringMessages_1 = require("../util/expiringMessages");
const notifications_1 = require("../util/notifications");
const storage_1 = require("../util/storage");
const linkPreviews_1 = require("../util/linkPreviews");
const reactions_1 = require("../util/reactions");
const initializeAttachmentMetadata_1 = require("../types/message/initializeAttachmentMetadata");
function arrayContainsUsOnly(arrayToCheck) {
    return (arrayToCheck &&
        arrayToCheck.length === 1 &&
        (arrayToCheck[0] === utils_1.UserUtils.getOurPubKeyStrFromCache() ||
            arrayToCheck[0].toLowerCase() === 'you'));
}
exports.arrayContainsUsOnly = arrayContainsUsOnly;
function arrayContainsOneItemOnly(arrayToCheck) {
    return arrayToCheck && arrayToCheck.length === 1;
}
exports.arrayContainsOneItemOnly = arrayContainsOneItemOnly;
class MessageModel extends backbone_1.default.Model {
    constructor(attributes) {
        const filledAttrs = (0, messageType_1.fillMessageAttributesWithDefaults)(attributes);
        super(filledAttrs);
        if (!this.attributes.id) {
            throw new Error('A message always needs to have an id.');
        }
        if (!this.attributes.conversationId) {
            throw new Error('A message always needs to have an conversationId.');
        }
        if (!attributes.skipTimerInit) {
            void this.setToExpire();
        }
        (0, auto_bind_1.default)(this);
        if (window) {
            window.contextMenuShown = false;
        }
        this.getMessageModelProps();
    }
    getMessageModelProps() {
        (0, Performance_1.perfStart)(`getPropsMessage-${this.id}`);
        const propsForDataExtractionNotification = this.getPropsForDataExtractionNotification();
        const propsForGroupInvitation = this.getPropsForGroupInvitation();
        const propsForPayment = this.getPropsForPayment();
        const propsForSharedContact = this.getPropsForSharedContact();
        const propsForGroupUpdateMessage = this.getPropsForGroupUpdateMessage();
        const propsForTimerNotification = this.getPropsForTimerNotification();
        const propsForMessageRequestResponse = this.getPropsForMessageRequestResponse();
        const callNotificationType = this.get('callNotificationType');
        const messageProps = {
            propsForMessage: this.getPropsForMessage(),
        };
        if (propsForDataExtractionNotification) {
            messageProps.propsForDataExtractionNotification = propsForDataExtractionNotification;
        }
        if (propsForMessageRequestResponse) {
            messageProps.propsForMessageRequestResponse = propsForMessageRequestResponse;
        }
        if (propsForPayment) {
            messageProps.propsForPayment = propsForPayment;
        }
        if (propsForSharedContact) {
            messageProps.propsForSharedContact = propsForSharedContact;
        }
        if (propsForGroupInvitation) {
            messageProps.propsForGroupInvitation = propsForGroupInvitation;
        }
        if (propsForGroupUpdateMessage) {
            messageProps.propsForGroupUpdateMessage = propsForGroupUpdateMessage;
        }
        if (propsForTimerNotification) {
            messageProps.propsForTimerNotification = propsForTimerNotification;
        }
        if (callNotificationType) {
            messageProps.propsForCallNotification = {
                notificationType: callNotificationType,
                messageId: this.id,
                receivedAt: this.get('received_at') || Date.now(),
                isUnread: this.isUnread(),
            };
        }
        (0, Performance_1.perfEnd)(`getPropsMessage-${this.id}`, 'getPropsMessage');
        return messageProps;
    }
    idForLogging() {
        return `${this.get('source')} ${this.get('sent_at')}`;
    }
    isExpirationTimerUpdate() {
        const expirationTimerFlag = protobuf_1.SignalService.DataMessage.Flags.EXPIRATION_TIMER_UPDATE;
        const flags = this.get('flags');
        if (!flags) {
            return false;
        }
        return !!(flags & expirationTimerFlag);
    }
    isIncoming() {
        return this.get('type') === 'incoming';
    }
    isUnread() {
        return !!this.get('unread');
    }
    merge(model) {
        const attributes = model.attributes || model;
        const { unread } = attributes;
        if (unread === undefined) {
            this.set({ unread: 0 });
        }
        this.set(attributes);
    }
    isPayment() {
        return !!this.get('payment');
    }
    isSharedContact() {
        return !!this.get('sharedContact');
    }
    isGroupInvitation() {
        return !!this.get('groupInvitation');
    }
    isMessageRequestResponse() {
        return !!this.get('messageRequestResponse');
    }
    isDataExtractionNotification() {
        return !!this.get('dataExtractionNotification');
    }
    getNotificationText() {
        let description = this.getDescription();
        if (description) {
            const regex = new RegExp(`@${types_1.PubKey.regexForPubkeys}`, 'g');
            const pubkeysInDesc = description.match(regex);
            (pubkeysInDesc || []).forEach((pubkey) => {
                const displayName = (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey(pubkey.slice(1));
                if (displayName && displayName.length) {
                    description = description?.replace(pubkey, `@${displayName}`);
                }
            });
            return description;
        }
        if ((this.get('attachments') || []).length > 0) {
            return window.i18n('mediaMessage');
        }
        if (this.isExpirationTimerUpdate()) {
            const expireTimerUpdate = this.get('expirationTimerUpdate');
            if (!expireTimerUpdate || !expireTimerUpdate.expireTimer) {
                return window.i18n('disappearingMessagesDisabled');
            }
            return window.i18n('timerSetTo', [
                expiringMessages_1.ExpirationTimerOptions.getAbbreviated(expireTimerUpdate.expireTimer || 0),
            ]);
        }
        return '';
    }
    onDestroy() {
        void this.cleanup();
    }
    async cleanup() {
        await (0, MessageAttachment_1.deleteExternalMessageFiles)(this.attributes);
    }
    getPropsForTimerNotification() {
        if (!this.isExpirationTimerUpdate()) {
            return null;
        }
        const timerUpdate = this.get('expirationTimerUpdate');
        if (!timerUpdate || !timerUpdate.source) {
            return null;
        }
        const { expireTimer, fromSync, source } = timerUpdate;
        const timespan = expiringMessages_1.ExpirationTimerOptions.getName(expireTimer || 0);
        const disabled = !expireTimer;
        const basicProps = {
            ...this.findAndFormatContact(source),
            timespan,
            disabled,
            type: fromSync ? 'fromSync' : utils_1.UserUtils.isUsFromCache(source) ? 'fromMe' : 'fromOther',
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
        };
        return basicProps;
    }
    getPropsForPayment() {
        if (!this.isPayment()) {
            return null;
        }
        const Payment = this.get('payment');
        if (!Payment) {
            return null;
        }
        let direction = this.get('direction');
        if (!direction) {
            direction = this.get('type') === 'outgoing' ? 'outgoing' : 'incoming';
        }
        return {
            amount: Payment.amount,
            txnId: Payment.txnId,
            direction,
            acceptUrl: '',
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
        };
    }
    getPropsForSharedContact() {
        const sharedContact = this.get('sharedContact');
        if (!this.isSharedContact) {
            return null;
        }
        if (!sharedContact) {
            return null;
        }
        let direction = this.get('direction');
        if (!direction) {
            direction = this.get('type');
        }
        return {
            address: sharedContact.address,
            name: sharedContact.name,
            direction,
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
        };
    }
    getPropsForGroupInvitation() {
        if (!this.isGroupInvitation()) {
            return null;
        }
        const invitation = this.get('groupInvitation');
        let direction = this.get('direction');
        if (!direction) {
            direction = this.get('type') === 'outgoing' ? 'outgoing' : 'incoming';
        }
        let serverAddress = '';
        try {
            const url = new URL(invitation.url);
            serverAddress = url.origin;
        }
        catch (e) {
            window?.log?.warn('failed to get hostname from opengroupv2 invitation', invitation);
        }
        return {
            serverName: invitation.name,
            url: serverAddress,
            direction,
            acceptUrl: invitation.url,
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
        };
    }
    getPropsForDataExtractionNotification() {
        if (!this.isDataExtractionNotification()) {
            return null;
        }
        const dataExtractionNotification = this.get('dataExtractionNotification');
        if (!dataExtractionNotification) {
            window.log.warn('dataExtractionNotification should not happen');
            return null;
        }
        const contact = this.findAndFormatContact(dataExtractionNotification.source);
        return {
            ...dataExtractionNotification,
            name: contact.profileName || contact.name || dataExtractionNotification.source,
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
        };
    }
    getPropsForMessageRequestResponse() {
        if (!this.isMessageRequestResponse()) {
            return null;
        }
        const messageRequestResponse = this.get('messageRequestResponse');
        if (!messageRequestResponse) {
            window.log.warn('messageRequestResponse should not happen');
            return null;
        }
        const contact = this.findAndFormatContact(messageRequestResponse.source);
        return {
            ...messageRequestResponse,
            name: contact.profileName || contact.name || messageRequestResponse.source,
            messageId: this.id,
            receivedAt: this.get('received_at'),
            isUnread: this.isUnread(),
            conversationId: this.get('conversationId'),
            source: this.get('source'),
        };
    }
    findContact(pubkey) {
        return (0, conversations_1.getConversationController)().get(pubkey);
    }
    findAndFormatContact(pubkey) {
        const contactModel = this.findContact(pubkey);
        let profileName;
        let isMe = false;
        if (pubkey === utils_1.UserUtils.getOurPubKeyStrFromCache() ||
            (pubkey && pubkey.startsWith('bd') && (0, reactions_1.isUsAnySogsFromCache)(pubkey))) {
            profileName = window.i18n('you');
            isMe = true;
        }
        else {
            profileName = contactModel ? contactModel.getProfileName() : null;
        }
        return {
            pubkey: pubkey,
            avatarPath: contactModel ? contactModel.getAvatarPath() : null,
            name: (contactModel ? contactModel.getName() : null),
            profileName: profileName,
            title: (contactModel ? contactModel.getTitle() : null),
            isMe,
        };
    }
    getPropsForGroupUpdateMessage() {
        const groupUpdate = this.getGroupUpdateAsArray();
        if (!groupUpdate || lodash_1.default.isEmpty(groupUpdate)) {
            return null;
        }
        const sharedProps = {
            messageId: this.id,
            isUnread: this.isUnread(),
            receivedAt: this.get('received_at'),
        };
        if (groupUpdate.joined?.length) {
            const change = {
                type: 'add',
                added: groupUpdate.joined,
            };
            return { change, ...sharedProps };
        }
        if (groupUpdate.kicked?.length) {
            const change = {
                type: 'kicked',
                kicked: groupUpdate.kicked,
            };
            return { change, ...sharedProps };
        }
        if (groupUpdate.left?.length) {
            const change = {
                type: 'left',
                left: groupUpdate.left,
            };
            return { change, ...sharedProps };
        }
        if (groupUpdate.name) {
            const change = {
                type: 'name',
                newName: groupUpdate.name,
            };
            return { change, ...sharedProps };
        }
        const changeGeneral = {
            type: 'general',
        };
        return { change: changeGeneral, ...sharedProps };
    }
    getMessagePropStatus() {
        if (this.hasErrors()) {
            return 'error';
        }
        if (!this.isOutgoing()) {
            return undefined;
        }
        if (this.isDataExtractionNotification() || this.get('callNotificationType')) {
            return undefined;
        }
        const readBy = this.get('read_by') || [];
        if (storage_1.Storage.get(settings_key_1.SettingsKey.settingsReadReceipt) && readBy.length > 0) {
            return 'read';
        }
        const sent = this.get('sent');
        const sentTo = this.get('sent_to') || [];
        if (sent || sentTo.length > 0) {
            return 'sent';
        }
        return 'sending';
    }
    getPropsForMessage(options = {}) {
        const sender = this.getSource();
        const expirationLength = this.get('expireTimer') * 1000;
        const expireTimerStart = this.get('expirationStartTimestamp');
        const expirationTimestamp = expirationLength && expireTimerStart ? expireTimerStart + expirationLength : null;
        const attachments = this.get('attachments') || [];
        const isTrustedForAttachmentDownload = this.isTrustedForAttachmentDownload();
        const body = this.get('body');
        const props = {
            id: this.id,
            direction: (this.isIncoming() ? 'incoming' : 'outgoing'),
            timestamp: this.get('sent_at') || 0,
            sender,
            convoId: this.get('conversationId'),
        };
        if (body) {
            props.text = this.createNonBreakingLastSeparator(body);
        }
        if (this.get('isDeleted')) {
            props.isDeleted = this.get('isDeleted');
        }
        if (this.get('messageHash')) {
            props.messageHash = this.get('messageHash');
        }
        if (this.get('received_at')) {
            props.receivedAt = this.get('received_at');
        }
        if (this.get('serverTimestamp')) {
            props.serverTimestamp = this.get('serverTimestamp');
        }
        if (this.get('serverId')) {
            props.serverId = this.get('serverId');
        }
        if (expirationLength) {
            props.expirationLength = expirationLength;
        }
        if (expirationTimestamp) {
            props.expirationTimestamp = expirationTimestamp;
        }
        if (isTrustedForAttachmentDownload) {
            props.isTrustedForAttachmentDownload = isTrustedForAttachmentDownload;
        }
        const isUnread = this.isUnread();
        if (isUnread) {
            props.isUnread = isUnread;
        }
        const isExpired = this.isExpired();
        if (isExpired) {
            props.isExpired = isExpired;
        }
        const previews = this.getPropsForPreview();
        if (previews && previews.length) {
            props.previews = previews;
        }
        const reacts = this.getPropsForReacts();
        if (reacts && Object.keys(reacts).length) {
            props.reacts = reacts;
        }
        const quote = this.getPropsForQuote(options);
        if (quote) {
            props.quote = quote;
        }
        const status = this.getMessagePropStatus();
        if (status) {
            props.status = status;
        }
        const attachmentsProps = attachments.map(this.getPropsForAttachment);
        if (attachmentsProps && attachmentsProps.length) {
            props.attachments = attachmentsProps;
        }
        return props;
    }
    createNonBreakingLastSeparator(text) {
        const nbsp = '\xa0';
        const regex = /(\S)( +)(\S+\s*)$/;
        return text.replace(regex, (_match, start, spaces, end) => {
            const newSpaces = end.length < 12 ? lodash_1.default.reduce(spaces, accumulator => accumulator + nbsp, '') : spaces;
            return `${start}${newSpaces}${end}`;
        });
    }
    getPropsForReacts() {
        return this.get('reacts') || null;
    }
    processQuoteAttachment(attachment) {
        const { thumbnail } = attachment;
        const path = thumbnail && thumbnail.path && (0, MessageAttachment_1.getAbsoluteAttachmentPath)(thumbnail.path);
        const objectUrl = thumbnail && thumbnail.objectUrl;
        const thumbnailWithObjectUrl = !path && !objectUrl
            ? null
            :
                Object.assign({}, attachment.thumbnail || {}, {
                    objectUrl: path || objectUrl,
                });
        return Object.assign({}, attachment, {
            isVoiceMessage: (0, Attachment_1.isVoiceMessage)(attachment),
            thumbnail: thumbnailWithObjectUrl,
        });
    }
    getPropsForPreview() {
        const previews = this.get('preview') || null;
        if (!previews || previews.length === 0) {
            return null;
        }
        return previews.map((preview) => {
            let image = null;
            try {
                if (preview.image) {
                    image = this.getPropsForAttachment(preview.image);
                }
            }
            catch (e) {
                window?.log?.info('Failed to show preview');
            }
            return {
                ...preview,
                domain: linkPreviews_1.LinkPreviews.getDomain(preview.url),
                image,
            };
        });
    }
    getPropsForQuote(_options = {}) {
        const quote = this.get('quote');
        if (!quote) {
            return null;
        }
        const { author, id, referencedMessageNotFound, direction } = quote;
        const contact = author && (0, conversations_1.getConversationController)().get(author);
        const authorName = contact ? contact.getContactProfileNameOrShortenedPubKey() : null;
        const isFromMe = contact ? contact.id === utils_1.UserUtils.getOurPubKeyStrFromCache() : false;
        const firstAttachment = quote.attachments && quote.attachments[0];
        const quoteProps = {
            sender: author,
            messageId: id,
            authorName: authorName || 'Unknown',
        };
        if (referencedMessageNotFound) {
            quoteProps.referencedMessageNotFound = true;
        }
        if (!referencedMessageNotFound) {
            if (quote.text) {
                quoteProps.text = this.createNonBreakingLastSeparator(sliceQuoteText(quote.text));
            }
            const quoteAttachment = firstAttachment
                ? this.processQuoteAttachment(firstAttachment)
                : undefined;
            if (quoteAttachment) {
                quoteProps.attachment = quoteAttachment;
            }
        }
        if (quote.text && quote.text.startsWith(`{"kind"`)) {
            const parsed = JSON.parse(quote.text);
            if (parsed.kind['@type'] === 'OpenGroupInvitation') {
                quoteProps.text = 'Social group invitation';
            }
            if (parsed.kind['@type'] === 'SharedContact') {
                const namesArray = JSON.parse(parsed.kind.name);
                quoteProps.text =
                    namesArray.length > 1
                        ? `${namesArray[0]} and ${namesArray.length - 1} other${namesArray.length > 2 ? 's' : ''}`
                        : namesArray[0] ?? '';
                quoteProps.isSharedContact = true;
            }
            if (parsed.kind['@type'] === 'Payment') {
                const types = direction === 'incoming' ? 'Received' : 'Sent';
                const amount = parsed?.kind?.amount;
                quoteProps.text = `${window.i18n('paymentDetails', [types])} : ${amount} BDX`;
            }
        }
        if (isFromMe) {
            quoteProps.isFromMe = true;
        }
        return quoteProps;
    }
    getPropsForAttachment(attachment) {
        if (!attachment) {
            return null;
        }
        const { id, path, contentType, width, height, pending, flags, size, screenshot, thumbnail, fileName, caption, } = attachment;
        const isVoiceMessageBool = Boolean(flags && flags & protobuf_1.SignalService.AttachmentPointer.Flags.VOICE_MESSAGE) || false;
        return {
            id,
            contentType,
            caption,
            size: size || 0,
            width: width || 0,
            height: height || 0,
            path,
            fileName,
            fileSize: size ? (0, filesize_1.default)(size) : null,
            isVoiceMessage: isVoiceMessageBool,
            pending: Boolean(pending),
            url: path ? (0, MessageAttachment_1.getAbsoluteAttachmentPath)(path) : '',
            screenshot: screenshot
                ? {
                    ...screenshot,
                    url: (0, MessageAttachment_1.getAbsoluteAttachmentPath)(screenshot.path),
                }
                : null,
            thumbnail: thumbnail
                ? {
                    ...thumbnail,
                    url: (0, MessageAttachment_1.getAbsoluteAttachmentPath)(thumbnail.path),
                }
                : null,
        };
    }
    async getPropsForMessageDetail() {
        const phoneNumbers = this.isIncoming()
            ? [this.get('source')]
            : this.get('sent_to') || [];
        const allErrors = (this.get('errors') || []).map((error) => {
            return error;
        });
        const errors = lodash_1.default.reject(allErrors, error => Boolean(error.number));
        const errorsGroupedById = lodash_1.default.groupBy(allErrors, 'number');
        const finalContacts = await Promise.all((phoneNumbers || []).map(async (id) => {
            const errorsForContact = errorsGroupedById[id];
            const isOutgoingKeyError = false;
            const contact = this.findAndFormatContact(id);
            return {
                ...contact,
                status: this.getStatus(id) || this.getMessagePropStatus(),
                errors: errorsForContact,
                isOutgoingKeyError,
                isPrimaryDevice: true,
                profileName: contact.profileName,
            };
        }));
        const sortedContacts = lodash_1.default.sortBy(finalContacts, contact => `${contact.isPrimaryDevice ? '0' : '1'}${contact.pubkey}`);
        const toRet = {
            sentAt: this.get('sent_at') || 0,
            receivedAt: this.get('received_at') || 0,
            convoId: this.get('conversationId'),
            messageId: this.get('id'),
            errors,
            direction: this.get('direction'),
            contacts: sortedContacts || [],
        };
        return toRet;
    }
    async uploadData() {
        const finalAttachments = await Promise.all((this.get('attachments') || []).map(MessageAttachment_1.loadAttachmentData));
        const body = this.get('body');
        const quoteWithData = await (0, MessageAttachment_1.loadQuoteData)(this.get('quote'));
        const previewWithData = await (0, MessageAttachment_1.loadPreviewData)(this.get('preview'));
        const { hasAttachments, hasVisualMediaAttachments, hasFileAttachments } = (0, initializeAttachmentMetadata_1.getAttachmentMetadata)(this);
        this.set({ hasAttachments, hasVisualMediaAttachments, hasFileAttachments });
        await this.commit();
        const conversation = this.getConversation();
        let attachmentPromise;
        let linkPreviewPromise;
        let quotePromise;
        const { AttachmentFsV2Utils } = bchat_1.Utils;
        if (conversation?.isOpenGroupV2()) {
            const openGroupV2 = conversation.toOpenGroupV2();
            attachmentPromise = (0, AttachmentsV2_1.uploadAttachmentsV2)(finalAttachments, openGroupV2);
            linkPreviewPromise = (0, AttachmentsV2_1.uploadLinkPreviewsV2)(previewWithData, openGroupV2);
            quotePromise = (0, AttachmentsV2_1.uploadQuoteThumbnailsV2)(openGroupV2, quoteWithData);
        }
        else {
            attachmentPromise = AttachmentFsV2Utils.uploadAttachmentsToFsV2(finalAttachments);
            linkPreviewPromise = AttachmentFsV2Utils.uploadLinkPreviewsToFsV2(previewWithData);
            quotePromise = AttachmentFsV2Utils.uploadQuoteThumbnailsToFsV2(quoteWithData);
        }
        const [attachments, preview, quote] = await Promise.all([
            attachmentPromise,
            linkPreviewPromise,
            quotePromise,
        ]);
        window.log.info(`Upload of message data for message ${this.idForLogging()} is finished.`);
        return {
            body,
            attachments,
            preview,
            quote,
        };
    }
    async markAsDeleted() {
        this.set({
            isDeleted: true,
            body: window.i18n('messageDeletedPlaceholder'),
            quote: undefined,
            groupInvitation: undefined,
            dataExtractionNotification: undefined,
            hasAttachments: 0,
            hasFileAttachments: 0,
            hasVisualMediaAttachments: 0,
            attachments: undefined,
            preview: undefined,
            reacts: undefined,
            reactsIndex: undefined,
        });
        await this.markRead(Date.now());
        await this.commit();
    }
    async retrySend() {
        if (!window.isOnline) {
            window?.log?.error('retrySend: Cannot retry since we are offline!');
            return null;
        }
        this.set({ errors: null });
        await this.commit();
        try {
            const conversation = this.getConversation();
            if (!conversation) {
                window?.log?.info('cannot retry send message, the corresponding conversation was not found.');
                return;
            }
            if (conversation.isPublic()) {
                if (!conversation.isOpenGroupV2()) {
                    throw new Error('Only opengroupv2 are supported now');
                }
                const uploaded = await this.uploadData();
                const openGroupParams = {
                    identifier: this.id,
                    timestamp: Date.now(),
                    lokiProfile: utils_1.UserUtils.getOurProfile(),
                    ...uploaded,
                };
                const roomInfos = await (0, opengroups_1.getV2OpenGroupRoom)(conversation.id);
                if (!roomInfos) {
                    throw new Error('Could not find roomInfos for this conversation');
                }
                const openGroupMessage = new OpenGroupVisibleMessage_1.OpenGroupVisibleMessage(openGroupParams);
                return (0, bchat_1.getMessageQueue)().sendToOpenGroupV2(openGroupMessage, roomInfos);
            }
            const { body, attachments, preview, quote } = await this.uploadData();
            const chatParams = {
                identifier: this.id,
                body,
                timestamp: Date.now(),
                expireTimer: this.get('expireTimer'),
                attachments,
                preview,
                quote,
                lokiProfile: utils_1.UserUtils.getOurProfile(),
                reacts: this.get('reacts'),
            };
            if (!chatParams.lokiProfile) {
                delete chatParams.lokiProfile;
            }
            const chatMessage = new VisibleMessage_1.VisibleMessage(chatParams);
            if (conversation.isMe()) {
                return this.sendSyncMessageOnly(chatMessage);
            }
            if (conversation.isPrivate()) {
                return (0, bchat_1.getMessageQueue)().sendToPubKey(types_1.PubKey.cast(conversation.id), chatMessage);
            }
            if (!conversation.isMediumGroup()) {
                throw new Error('We should only end up with a medium group here. Anything else is an error');
            }
            const closedGroupVisibleMessage = new ClosedGroupVisibleMessage_1.ClosedGroupVisibleMessage({
                identifier: this.id,
                chatMessage,
                groupId: this.get('conversationId'),
            });
            return (0, bchat_1.getMessageQueue)().sendToGroup(closedGroupVisibleMessage);
        }
        catch (e) {
            await this.saveErrors(e);
            return null;
        }
    }
    removeOutgoingErrors(number) {
        const errors = lodash_1.default.partition(this.get('errors'), e => e.number === number && e.name === 'SendMessageNetworkError');
        this.set({ errors: errors[1] });
        return errors[0][0];
    }
    getConversation() {
        return (0, conversations_1.getConversationController)().getUnsafe(this.get('conversationId'));
    }
    getQuoteContact() {
        const quote = this.get('quote');
        if (!quote) {
            return null;
        }
        const { author } = quote;
        if (!author) {
            return null;
        }
        return (0, conversations_1.getConversationController)().get(author);
    }
    getSource() {
        if (this.isIncoming()) {
            return this.get('source');
        }
        return utils_1.UserUtils.getOurPubKeyStrFromCache();
    }
    getContact() {
        const source = this.getSource();
        if (!source) {
            return null;
        }
        return (0, conversations_1.getConversationController)().getOrCreate(source, conversation_1.ConversationTypeEnum.PRIVATE);
    }
    isOutgoing() {
        return this.get('type') === 'outgoing';
    }
    hasErrors() {
        return lodash_1.default.size(this.get('errors')) > 0;
    }
    getStatus(pubkey) {
        const readBy = this.get('read_by') || [];
        if (readBy.indexOf(pubkey) >= 0) {
            return 'read';
        }
        const sentTo = this.get('sent_to') || [];
        if (sentTo.indexOf(pubkey) >= 0) {
            return 'sent';
        }
        return null;
    }
    async updateMessageHash(messageHash) {
        if (!messageHash) {
            window?.log?.error('Message hash not provided to update message hash');
        }
        this.set({
            messageHash,
        });
        await this.commit();
    }
    async sendSyncMessageOnly(dataMessage) {
        const now = Date.now();
        this.set({
            sent_to: [utils_1.UserUtils.getOurPubKeyStrFromCache()],
            sent: true,
            expirationStartTimestamp: now,
        });
        await this.commit();
        const data = dataMessage instanceof outgoing_1.DataMessage ? dataMessage.dataProto() : dataMessage;
        await this.sendSyncMessage(data, now);
    }
    async sendSyncMessage(dataMessage, sentTimestamp) {
        if (this.get('synced') || this.get('sentSync')) {
            return;
        }
        if (dataMessage.body?.length ||
            dataMessage.attachments.length ||
            dataMessage.flags === protobuf_1.SignalService.DataMessage.Flags.EXPIRATION_TIMER_UPDATE ||
            dataMessage.sharedContact ||
            dataMessage.openGroupInvitation ||
            dataMessage.payment) {
            const conversation = this.getConversation();
            if (!conversation) {
                throw new Error('Cannot trigger syncMessage with unknown convo.');
            }
            const syncMessage = (0, syncUtils_1.buildSyncMessage)(this.id, dataMessage, conversation.id, sentTimestamp);
            await (0, bchat_1.getMessageQueue)().sendSyncMessage(syncMessage);
        }
        this.set({ sentSync: true });
        await this.commit();
    }
    async saveErrors(providedErrors) {
        let errors = providedErrors;
        if (!(errors instanceof Array)) {
            errors = [errors];
        }
        errors.forEach((e) => {
            window?.log?.error('Message.saveErrors:', e && e.reason ? e.reason : null, e && e.stack ? e.stack : e);
        });
        errors = errors.map((e) => {
            if (e.constructor === Error ||
                e.constructor === TypeError ||
                e.constructor === ReferenceError) {
                return lodash_1.default.pick(e, 'name', 'message', 'code', 'number', 'reason');
            }
            return e;
        });
        errors = errors.concat(this.get('errors') || []);
        this.set({ errors });
        await this.commit();
    }
    async commit(triggerUIUpdate = true) {
        if (!this.attributes.id) {
            throw new Error('A message always needs an id');
        }
        (0, Performance_1.perfStart)(`messageCommit-${this.attributes.id}`);
        const id = await (0, data_1.saveMessage)(lodash_1.default.cloneDeep(this.attributes));
        if (triggerUIUpdate) {
            this.dispatchMessageUpdate();
        }
        (0, Performance_1.perfEnd)(`messageCommit-${this.attributes.id}`, 'messageCommit');
        return id;
    }
    async markRead(readAt) {
        this.markReadNoCommit(readAt);
        await this.commit();
        await this.setToExpire();
        const convo = this.getConversation();
        if (convo) {
            const beforeUnread = convo.get('unreadCount');
            const unreadCount = await convo.getUnreadCount();
            const nextMentionedUs = await (0, data_1.getFirstUnreadMessageWithMention)(convo.id, utils_1.UserUtils.getOurPubKeyStrFromCache());
            let mentionedUsChange = false;
            if (convo.get('mentionedUs') && !nextMentionedUs) {
                convo.set('mentionedUs', false);
                mentionedUsChange = true;
            }
            if (beforeUnread !== unreadCount || mentionedUsChange) {
                convo.set({ unreadCount });
                await convo.commit();
            }
        }
    }
    markReadNoCommit(readAt) {
        this.set({ unread: 0 });
        if (this.get('expireTimer') && !this.get('expirationStartTimestamp')) {
            const expirationStartTimestamp = Math.min(Date.now(), readAt || Date.now());
            this.set({ expirationStartTimestamp });
        }
        notifications_1.Notifications.clearByMessageId(this.id);
    }
    isExpiring() {
        return this.get('expireTimer') && this.get('expirationStartTimestamp');
    }
    isExpired() {
        return this.msTilExpire() <= 0;
    }
    msTilExpire() {
        if (!this.isExpiring()) {
            return Infinity;
        }
        const now = Date.now();
        const start = this.get('expirationStartTimestamp');
        if (!start) {
            return Infinity;
        }
        const delta = this.get('expireTimer') * 1000;
        let msFromNow = start + delta - now;
        if (msFromNow < 0) {
            msFromNow = 0;
        }
        return msFromNow;
    }
    async setToExpire(force = false) {
        if (this.isExpiring() && (force || !this.get('expires_at'))) {
            const start = this.get('expirationStartTimestamp');
            const delta = this.get('expireTimer') * 1000;
            if (!start) {
                return;
            }
            const expiresAt = start + delta;
            this.set({ expires_at: expiresAt });
            const id = this.get('id');
            if (id) {
                await this.commit();
            }
            window?.log?.info('Set message expiration', {
                expiresAt,
                sentAt: this.get('sent_at'),
            });
        }
    }
    isTrustedForAttachmentDownload() {
        try {
            const senderConvoId = this.getSource();
            const isClosedGroup = this.getConversation()?.isClosedGroup() || false;
            if (!!this.get('isPublic') || isClosedGroup || (0, User_1.isUsFromCache)(senderConvoId)) {
                return true;
            }
            const senderConvo = (0, conversations_1.getConversationController)().get(senderConvoId);
            if (!senderConvo) {
                return false;
            }
            return senderConvo.get('isTrustedForAttachmentDownload') || false;
        }
        catch (e) {
            window.log.warn('isTrustedForAttachmentDownload: error; ', e.message);
            return false;
        }
    }
    dispatchMessageUpdate() {
        updatesToDispatch.set(this.id, this.getMessageModelProps());
        throttledAllMessagesDispatch();
    }
    getGroupUpdateAsArray() {
        const groupUpdate = this.get('group_update');
        if (!groupUpdate || lodash_1.default.isEmpty(groupUpdate)) {
            return undefined;
        }
        const left = Array.isArray(groupUpdate.left)
            ? groupUpdate.left
            : groupUpdate.left
                ? [groupUpdate.left]
                : undefined;
        const kicked = Array.isArray(groupUpdate.kicked)
            ? groupUpdate.kicked
            : groupUpdate.kicked
                ? [groupUpdate.kicked]
                : undefined;
        const joined = Array.isArray(groupUpdate.joined)
            ? groupUpdate.joined
            : groupUpdate.joined
                ? [groupUpdate.joined]
                : undefined;
        const forcedArrayUpdate = {};
        if (left) {
            forcedArrayUpdate.left = left;
        }
        if (joined) {
            forcedArrayUpdate.joined = joined;
        }
        if (kicked) {
            forcedArrayUpdate.kicked = kicked;
        }
        if (groupUpdate.name) {
            forcedArrayUpdate.name = groupUpdate.name;
        }
        return forcedArrayUpdate;
    }
    getDescription() {
        const groupUpdate = this.getGroupUpdateAsArray();
        if (groupUpdate) {
            if (arrayContainsUsOnly(groupUpdate.kicked)) {
                return window.i18n('youGotKickedFromGroup');
            }
            if (arrayContainsUsOnly(groupUpdate.left)) {
                return window.i18n('youLeftTheGroup');
            }
            if (groupUpdate.left && groupUpdate.left.length === 1) {
                return window.i18n('leftTheGroup', [
                    (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey(groupUpdate.left[0]),
                ]);
            }
            const messages = [];
            if (!groupUpdate.name && !groupUpdate.joined && !groupUpdate.kicked && !groupUpdate.kicked) {
                return window.i18n('updatedTheGroup');
            }
            if (groupUpdate.name) {
                return window.i18n('titleIsNow', [groupUpdate.name]);
            }
            if (groupUpdate.joined && groupUpdate.joined.length) {
                const names = groupUpdate.joined.map((pubKey) => (0, conversations_1.getConversationController)().getContactProfileNameOrFullPubKey(pubKey));
                if (names.length > 1) {
                    messages.push(window.i18n('multipleJoinedTheGroup', [names.join(', ')]));
                }
                else {
                    messages.push(window.i18n('joinedTheGroup', names));
                }
            }
            if (groupUpdate.kicked && groupUpdate.kicked.length) {
                const names = lodash_1.default.map(groupUpdate.kicked, (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey);
                if (names.length > 1) {
                    messages.push(window.i18n('multipleKickedFromTheGroup', [names.join(', ')]));
                }
                else {
                    messages.push(window.i18n('kickedFromTheGroup', names));
                }
            }
            return messages.join(' ');
        }
        if (this.isIncoming() && this.hasErrors()) {
            return window.i18n('incomingError');
        }
        if (this.isGroupInvitation()) {
            return `😎 ${window.i18n('socialGroupInvitation')}`;
        }
        if (this.isPayment()) {
            let amount = this.getMessageModelProps()?.propsForPayment?.amount;
            let direction = this.getMessageModelProps()?.propsForPayment?.direction === 'outgoing'
                ? 'Send'
                : 'Received';
            return `${amount} BDX ${direction}`;
        }
        if (this.isSharedContact()) {
            return `Shared contact`;
        }
        if (this.isDataExtractionNotification()) {
            const dataExtraction = this.get('dataExtractionNotification');
            if (dataExtraction.type === protobuf_1.SignalService.DataExtractionNotification.Type.SCREENSHOT) {
                return window.i18n('tookAScreenshot', [
                    (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey(dataExtraction.source),
                ]);
            }
            return window.i18n('savedTheFile', [
                (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey(dataExtraction.source),
            ]);
        }
        if (this.get('callNotificationType')) {
            const displayName = (0, conversations_1.getConversationController)().getContactProfileNameOrShortenedPubKey(this.get('conversationId'));
            const callNotificationType = this.get('callNotificationType');
            if (callNotificationType === 'missed-call') {
                return window.i18n('callMissed', [displayName]);
            }
            if (callNotificationType === 'started-call') {
                return window.i18n('startedACall', [displayName]);
            }
            if (callNotificationType === 'answered-a-call') {
                return window.i18n('answeredACall', [displayName]);
            }
        }
        if (this.get('reaction')) {
            const reaction = this.get('reaction');
            if (reaction && reaction.emoji && reaction.emoji !== '') {
                return window.i18n('reactionNotification', [reaction.emoji]);
            }
        }
        return this.get('body');
    }
}
exports.MessageModel = MessageModel;
function sliceQuoteText(quotedText) {
    if (!quotedText || (0, lodash_1.isEmpty)(quotedText)) {
        return '';
    }
    return quotedText.slice(0, 60);
}
exports.sliceQuoteText = sliceQuoteText;
const throttledAllMessagesDispatch = lodash_1.default.debounce(() => {
    if (updatesToDispatch.size === 0) {
        return;
    }
    window.inboxStore?.dispatch((0, conversations_2.messagesChanged)([...updatesToDispatch.values()]));
    updatesToDispatch.clear();
}, 500, { trailing: true, leading: true, maxWait: 1000 });
const updatesToDispatch = new Map();
class MessageCollection extends backbone_1.default.Collection {
}
exports.MessageCollection = MessageCollection;
MessageCollection.prototype.model = MessageModel;
