"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = void 0;
const path_1 = __importDefault(require("path"));
const electron_is_dev_1 = __importDefault(require("electron-is-dev"));
let environment;
if (electron_is_dev_1.default) {
    environment = process.env.NODE_ENV || 'development';
}
else {
    environment = 'production';
}
process.env.NODE_ENV = environment;
process.env.NODE_CONFIG_DIR = path_1.default.join(__dirname, '..', '..', 'config');
if (environment === 'production') {
    process.env.NODE_CONFIG = '';
    process.env.NODE_CONFIG_STRICT_MODE = `${!electron_is_dev_1.default}`;
    process.env.HOSTNAME = '';
    process.env.ALLOW_CONFIG_MUTATIONS = '';
    process.env.SUPPRESS_NO_CONFIG_WARNING = '';
    process.env.GITHUB_TOKEN = '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';
    if (!electron_is_dev_1.default) {
        process.env.NODE_APP_INSTANCE = '';
    }
}
const c = require('config');
c.environment = environment;
['NODE_ENV', 'NODE_APP_INSTANCE', 'NODE_CONFIG_DIR', 'NODE_CONFIG'].forEach(s => {
    console.log(`${s} ${c.util.getEnv(s)}`);
});
exports.config = c;
