"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupGlobalErrorHandler = exports.updateLocale = void 0;
const electron_1 = require("electron");
const privacy_1 = require("../util/privacy");
let quitText = 'Quit';
let copyErrorAndQuitText = 'Copy error and quit';
async function handleError(prefix, error) {
    if (console._error) {
        console._error(`${prefix}:`, error);
    }
    console.error(`${prefix}:`, error);
    if (electron_1.app.isReady()) {
        const button = await electron_1.dialog.showMessageBox({
            buttons: [quitText, copyErrorAndQuitText],
            defaultId: 0,
            detail: (0, privacy_1.redactAll)(error.stack),
            message: prefix,
            noLink: true,
            type: 'error',
        });
        if (button.response === 1) {
            electron_1.clipboard.writeText(`${prefix}\n\n${(0, privacy_1.redactAll)(error.stack)}`);
        }
    }
    else {
        electron_1.dialog.showErrorBox(prefix, error.stack);
    }
    electron_1.app.exit(1);
}
const updateLocale = (messages) => {
    quitText = messages.quit;
    copyErrorAndQuitText = messages.copyErrorAndQuit;
};
exports.updateLocale = updateLocale;
const setupGlobalErrorHandler = () => {
    process.on('uncaughtException', async (error) => {
        await handleError('Unhandled Error', error);
    });
    process.on('unhandledRejection', async (error) => {
        await handleError('Unhandled Promise Rejection', error);
    });
};
exports.setupGlobalErrorHandler = setupGlobalErrorHandler;
