"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTemplate = void 0;
const lodash_1 = require("lodash");
const createTemplate = (options, messages) => {
    if (!(0, lodash_1.isString)(options.platform)) {
        throw new TypeError('`options.platform` must be a string');
    }
    const { openReleaseNotes, openSupportPage, platform, showAbout, showDebugLog, showWindow, } = options;
    const template = [
        {
            label: messages.mainMenuFile,
            submenu: [
                {
                    type: 'separator',
                },
                {
                    role: 'quit',
                    label: messages.appMenuQuit,
                },
            ],
        },
        {
            label: messages.mainMenuEdit,
            submenu: [
                {
                    role: 'undo',
                    label: messages.editMenuUndo,
                },
                {
                    role: 'redo',
                    label: messages.editMenuRedo,
                },
                {
                    type: 'separator',
                },
                {
                    role: 'cut',
                    label: messages.editMenuCut,
                },
                {
                    role: 'copy',
                    label: messages.editMenuCopy,
                },
                {
                    role: 'paste',
                    label: messages.editMenuPaste,
                },
                {
                    role: 'delete',
                    label: messages.delete,
                },
                {
                    role: 'selectall',
                    label: messages.editMenuSelectAll,
                },
            ],
        },
        {
            label: messages.mainMenuView,
            submenu: [
                {
                    role: 'resetzoom',
                    label: messages.viewMenuResetZoom,
                },
                {
                    accelerator: platform === 'darwin' ? 'Command+=' : 'Control+Plus',
                    role: 'zoomin',
                    label: messages.viewMenuZoomIn,
                },
                {
                    role: 'zoomout',
                    label: messages.viewMenuZoomOut,
                },
                {
                    type: 'separator',
                },
                {
                    role: 'togglefullscreen',
                    label: messages.viewMenuToggleFullScreen,
                },
                {
                    type: 'separator',
                },
                {
                    label: messages.debugLog,
                    click: showDebugLog,
                },
                {
                    type: 'separator',
                },
                {
                    role: 'toggledevtools',
                    label: messages.viewMenuToggleDevTools,
                },
            ],
        },
        {
            label: messages.mainMenuWindow,
            role: 'window',
            submenu: [
                {
                    role: 'minimize',
                    label: messages.windowMenuMinimize,
                },
            ],
        },
        {
            label: messages.mainMenuHelp,
            role: 'help',
            submenu: [
                {
                    label: messages.goToReleaseNotes,
                    click: openReleaseNotes,
                },
                {
                    type: 'separator',
                },
                {
                    label: messages.goToSupportPage,
                    click: openSupportPage,
                },
                {
                    type: 'separator',
                },
                {
                    label: messages.about,
                    click: showAbout,
                },
            ],
        },
    ];
    if (platform === 'darwin') {
        return updateForMac(template, messages, {
            showAbout: showAbout,
            showWindow: showWindow,
        });
    }
    return template;
};
exports.createTemplate = createTemplate;
function updateForMac(template, messages, options) {
    const { showAbout, showWindow } = options;
    template[4].submenu.pop();
    template[4].submenu.pop();
    template.shift();
    template.unshift({
        label: messages.sessionMessenger,
        submenu: [
            {
                label: messages.about,
                click: showAbout,
            },
            {
                type: 'separator',
            },
            {
                type: 'separator',
            },
            {
                label: messages.appMenuHide,
                role: 'hide',
            },
            {
                label: messages.appMenuHideOthers,
                role: 'hideothers',
            },
            {
                label: messages.appMenuUnhide,
                role: 'unhide',
            },
            {
                type: 'separator',
            },
            {
                label: messages.appMenuQuit,
                role: 'quit',
            },
        ],
    });
    const windowMenuTemplateIndex = 3;
    template[windowMenuTemplateIndex].submenu = [
        {
            label: messages.windowMenuClose,
            accelerator: 'CmdOrCtrl+W',
            role: 'close',
        },
        {
            label: messages.windowMenuMinimize,
            accelerator: 'CmdOrCtrl+M',
            role: 'minimize',
        },
        {
            label: messages.windowMenuZoom,
            role: 'zoom',
        },
        {
            label: messages.show,
            click: showWindow,
        },
    ];
    return template;
}
