"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.installPermissionsHandler = void 0;
const electron_1 = require("electron");
const PERMISSIONS = {
    fullscreen: true,
    notifications: true,
    media: false,
    geolocation: false,
    midiSysex: false,
    openExternal: false,
    pointerLock: false,
};
function createPermissionHandler(userConfig) {
    return (_webContents, permission, callback) => {
        if (permission === 'media' && userConfig.get('mediaPermissions')) {
            return callback(true);
        }
        if (PERMISSIONS[permission]) {
            console.log(`Approving request for permission '${permission}'`);
            return callback(true);
        }
        console.log(`Denying request for permission '${permission}'`);
        return callback(false);
    };
}
function installPermissionsHandler({ userConfig }) {
    electron_1.session.defaultSession.setPermissionRequestHandler(null);
    electron_1.session.defaultSession.setPermissionRequestHandler(createPermissionHandler(userConfig));
}
exports.installPermissionsHandler = installPermissionsHandler;
