"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setup = void 0;
const electron_1 = require("electron");
const os_locale_1 = require("os-locale");
const setup = (browserWindow, messages) => {
    const { session } = browserWindow.webContents;
    const userLocale = (0, os_locale_1.sync)().replace(/_/g, '-');
    const userLocales = [userLocale, userLocale.split('-')[0]];
    const available = session.availableSpellCheckerLanguages;
    const languages = userLocales.filter(l => available.includes(l));
    console.log(`spellcheck: user locale: ${userLocale}`);
    console.log('spellcheck: available spellchecker languages: ', available);
    console.log('spellcheck: setting languages to: ', languages);
    session.setSpellCheckerLanguages(languages);
    browserWindow.webContents.on('context-menu', (_event, params) => {
        const { editFlags } = params;
        const isMisspelled = Boolean(params.misspelledWord);
        const showMenu = params.isEditable || editFlags.canCopy;
        if (showMenu) {
            const template = [];
            if (isMisspelled) {
                if (params.dictionarySuggestions.length > 0) {
                    template.push(...params.dictionarySuggestions.map((label) => ({
                        label,
                        click: () => {
                            browserWindow.webContents.replaceMisspelling(label);
                        },
                    })));
                }
                else {
                    template.push({
                        label: messages.contextMenuNoSuggestions,
                        enabled: false,
                    });
                }
                template.push({ type: 'separator' });
            }
            if (params.isEditable) {
                if (editFlags.canUndo) {
                    template.push({ label: messages.editMenuUndo, role: 'undo' });
                }
                if (editFlags.canRedo) {
                    template.push({ label: messages.editMenuRedo, role: 'redo' });
                }
                if (editFlags.canUndo || editFlags.canRedo) {
                    template.push({ type: 'separator' });
                }
                if (editFlags.canCut) {
                    template.push({ label: messages.editMenuCut, role: 'cut' });
                }
            }
            if (editFlags.canPaste) {
                template.push({ label: messages.editMenuPaste, role: 'paste' });
            }
            if (editFlags.canSelectAll && params.isEditable) {
                template.push({
                    label: messages.editMenuSelectAll,
                    role: 'selectall',
                });
            }
            const menu = electron_1.Menu.buildFromTemplate(template);
            menu.popup({ window: browserWindow });
        }
    });
};
exports.setup = setup;
