"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTrayIcon = void 0;
const path_1 = __importDefault(require("path"));
const electron_1 = require("electron");
const getRootPath_1 = require("./getRootPath");
let trayContextMenu = null;
let tray = null;
let trayAny;
function createTrayIcon(getMainWindow, messages) {
    const iconFile = process.platform === 'darwin' ? 'bchat_logo_16.png' : 'bchat_logo.png';
    const iconNoNewMessages = path_1.default.join((0, getRootPath_1.getAppRootPath)(), 'images', 'bchat', iconFile);
    tray = new electron_1.Tray(iconNoNewMessages);
    trayAny = tray;
    trayAny.forceOnTop = (mainWindow) => {
        if (mainWindow) {
            mainWindow.setAlwaysOnTop(true);
            mainWindow.focus();
            mainWindow.setAlwaysOnTop(false);
        }
    };
    trayAny.toggleWindowVisibility = () => {
        const mainWindow = getMainWindow();
        if (mainWindow) {
            if (mainWindow.isVisible()) {
                mainWindow.hide();
            }
            else {
                mainWindow.show();
                trayAny.forceOnTop(mainWindow);
            }
        }
        trayAny.updateContextMenu();
    };
    trayAny.showWindow = () => {
        const mainWindow = getMainWindow();
        if (mainWindow) {
            if (!mainWindow.isVisible()) {
                mainWindow.show();
            }
            trayAny.forceOnTop(mainWindow);
        }
        trayAny.updateContextMenu();
    };
    trayAny.updateContextMenu = () => {
        const mainWindow = getMainWindow();
        trayContextMenu = electron_1.Menu.buildFromTemplate([
            {
                id: 'toggleWindowVisibility',
                label: messages[mainWindow?.isVisible() ? 'appMenuHide' : 'show'],
                click: trayAny.toggleWindowVisibility,
            },
            {
                id: 'quit',
                label: messages.appMenuQuit,
                click: electron_1.app.quit.bind(electron_1.app),
            },
        ]);
        trayAny.setContextMenu(trayContextMenu);
    };
    tray.on('click', trayAny.showWindow);
    tray.setToolTip(messages.sessionMessenger);
    trayAny.updateContextMenu();
    return tray;
}
exports.createTrayIcon = createTrayIcon;
