"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapDispatchToProps = void 0;
const redux_1 = require("redux");
const search_1 = require("./ducks/search");
const conversations_1 = require("./ducks/conversations");
const user_1 = require("./ducks/user");
const section_1 = require("./ducks/section");
const theme_1 = require("./ducks/theme");
const modalDialog_1 = require("./ducks/modalDialog");
const walletSection_1 = require("./ducks/walletSection");
const wallet_1 = require("./ducks/wallet");
const walletInnerSection_1 = require("./ducks/walletInnerSection");
const walletConfig_1 = require("./ducks/walletConfig");
function mapDispatchToProps(dispatch) {
    return {
        ...(0, redux_1.bindActionCreators)({
            ...search_1.actions,
            ...conversations_1.actions,
            ...user_1.actions,
            ...theme_1.actions,
            ...section_1.actions,
            ...modalDialog_1.actions,
            ...wallet_1.actions,
            ...walletSection_1.action,
            ...walletInnerSection_1.action,
            ...walletConfig_1.actions
        }, dispatch),
    };
}
exports.mapDispatchToProps = mapDispatchToProps;
