"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.openConversationToSpecificMessage = exports.openConversationWithMessages = exports.updateViewContactPanel = exports.closeShareContact = exports.openShareContact = exports.resetConversationExternal = exports.updateMentionsMembers = exports.setNextMessageToPlayId = exports.quotedMessageToAnimate = exports.showScrollToBottomButton = exports.quoteMessage = exports.showLightBox = exports.toggleSelectedMessageId = exports.resetSelectedMessageIds = exports.addMessageIdToSelection = exports.closeRightPanel = exports.openRightPanel = exports.closeMessageDetailsView = exports.showMessageDetailsView = exports.markConversationFullyRead = exports.resetOldBottomMessageId = exports.resetOldTopMessageId = exports.messagesChanged = exports.conversationReset = exports.messageDeleted = exports.messageExpired = exports.removeAllConversations = exports.conversationRemoved = exports.conversationsChanged = exports.conversationChanged = exports.conversationAdded = exports.reducer = exports.actions = exports.getEmptyConversationState = exports.fetchBottomMessagesForConversation = exports.fetchTopMessagesForConversation = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
const conversations_1 = require("../../bchat/conversations");
const data_1 = require("../../data/data");
const lodash_1 = require("lodash");
async function getMessages({ conversationKey, messageId, }) {
    const beforeTimestamp = Date.now();
    const conversation = (0, conversations_1.getConversationController)().get(conversationKey);
    if (!conversation) {
        window?.log?.error('Failed to get convo on reducer.');
        return [];
    }
    const messageSet = await (0, data_1.getMessagesByConversation)(conversationKey, {
        messageId,
    });
    const messageProps = messageSet.models.map(m => m.getMessageModelProps());
    const time = Date.now() - beforeTimestamp;
    window?.log?.info(`Loading ${messageProps.length} messages took ${time}ms to load.`);
    return messageProps;
}
exports.fetchTopMessagesForConversation = (0, toolkit_1.createAsyncThunk)('messages/fetchTopByConversationKey', async ({ conversationKey, oldTopMessageId, }) => {
    const oldestMessage = await (0, data_1.getOldestMessageInConversation)(conversationKey);
    if (!oldestMessage || oldestMessage.id === oldTopMessageId) {
        window.log.info('fetchTopMessagesForConversation: we are already at the top');
        return null;
    }
    const messagesProps = await getMessages({
        conversationKey,
        messageId: oldTopMessageId,
    });
    return {
        conversationKey,
        messagesProps,
        oldTopMessageId,
    };
});
exports.fetchBottomMessagesForConversation = (0, toolkit_1.createAsyncThunk)('messages/fetchBottomByConversationKey', async ({ conversationKey, oldBottomMessageId, }) => {
    const mostRecentMessage = await (0, data_1.getLastMessageInConversation)(conversationKey);
    if (!mostRecentMessage || mostRecentMessage.id === oldBottomMessageId) {
        window.log.info('fetchBottomMessagesForConversation: we are already at the bottom');
        return null;
    }
    const messagesProps = await getMessages({
        conversationKey,
        messageId: oldBottomMessageId,
    });
    return {
        conversationKey,
        messagesProps,
        oldBottomMessageId,
        newMostRecentMessageIdInConversation: mostRecentMessage.id,
    };
});
function getEmptyConversationState() {
    return {
        conversationLookup: {},
        messages: [],
        messageDetailProps: undefined,
        showRightPanel: false,
        selectedMessageIds: [],
        areMoreMessagesBeingFetched: false,
        showScrollButton: false,
        mentionMembers: [],
        firstUnreadMessageId: undefined,
        oldTopMessageId: null,
        oldBottomMessageId: null,
        shouldHighlightMessage: false,
        mostRecentMessageId: null,
        showShareContact: false,
        showViewContactPanel: null,
    };
}
exports.getEmptyConversationState = getEmptyConversationState;
function handleMessageChangedOrAdded(state, changedOrAddedMessageProps) {
    if (changedOrAddedMessageProps.propsForMessage.convoId !== state.selectedConversation) {
        return state;
    }
    const messageInStoreIndex = state.messages.findIndex(m => m.propsForMessage.id === changedOrAddedMessageProps.propsForMessage.id);
    if (messageInStoreIndex >= 0) {
        state.messages[messageInStoreIndex] = changedOrAddedMessageProps;
        return state;
    }
    if (state.showScrollButton) {
        return state;
    }
    state.messages.push(changedOrAddedMessageProps);
    return state;
}
function handleMessagesChangedOrAdded(state, payload) {
    payload.forEach(element => {
        state = handleMessageChangedOrAdded(state, element);
    });
    return state;
}
function handleMessageExpiredOrDeleted(state, action) {
    const { conversationKey, messageId } = action.payload;
    if (conversationKey === state.selectedConversation) {
        const messageInStoreIndex = state?.messages.findIndex(m => m.propsForMessage.id === messageId);
        if (messageInStoreIndex >= 0) {
            const editedMessages = [
                ...state.messages.slice(0, messageInStoreIndex),
                ...state.messages.slice(messageInStoreIndex + 1),
            ];
            return {
                ...state,
                messages: editedMessages,
                firstUnreadMessageId: state.firstUnreadMessageId === messageId ? undefined : state.firstUnreadMessageId,
            };
        }
        return state;
    }
    return state;
}
function handleConversationReset(state, action) {
    const conversationKey = action.payload;
    if (conversationKey === state.selectedConversation) {
        return {
            ...state,
            messages: [],
        };
    }
    return state;
}
const conversationsSlice = (0, toolkit_1.createSlice)({
    name: 'conversations',
    initialState: getEmptyConversationState(),
    reducers: {
        showMessageDetailsView(state, action) {
            return { ...state, messageDetailProps: action.payload, showRightPanel: false };
        },
        closeMessageDetailsView(state) {
            return { ...state, messageDetailProps: undefined };
        },
        openRightPanel(state) {
            return { ...state, showRightPanel: true };
        },
        openShareContact(state) {
            return { ...state, showShareContact: true };
        },
        closeRightPanel(state) {
            return { ...state, showRightPanel: false };
        },
        closeShareContact(state) {
            return { ...state, showShareContact: false };
        },
        updateViewContactPanel(state, action) {
            return { ...state, showViewContactPanel: action.payload };
        },
        addMessageIdToSelection(state, action) {
            if (state.selectedMessageIds.some(id => id === action.payload)) {
                return state;
            }
            return { ...state, selectedMessageIds: [...state.selectedMessageIds, action.payload] };
        },
        removeMessageIdFromSelection(state, action) {
            const index = state.selectedMessageIds.findIndex(id => id === action.payload);
            if (index === -1) {
                return state;
            }
            return { ...state, selectedMessageIds: state.selectedMessageIds.splice(index, 1) };
        },
        toggleSelectedMessageId(state, action) {
            const index = state.selectedMessageIds.findIndex(id => id === action.payload);
            if (index === -1) {
                state.selectedMessageIds = [...state.selectedMessageIds, action.payload];
            }
            else {
                state.selectedMessageIds.splice(index, 1);
            }
            return state;
        },
        resetSelectedMessageIds(state) {
            return { ...state, selectedMessageIds: [] };
        },
        conversationAdded(state, action) {
            const { conversationLookup } = state;
            return {
                ...state,
                conversationLookup: {
                    ...conversationLookup,
                    [action.payload.id]: action.payload.data,
                },
            };
        },
        conversationChanged(state, action) {
            const { payload } = action;
            return applyConversationChanged(state, payload);
        },
        conversationsChanged(state, action) {
            const { payload } = action;
            let updatedState = state;
            if (payload.length) {
                payload.forEach(convoProps => {
                    updatedState = applyConversationChanged(updatedState, {
                        id: convoProps.id,
                        data: convoProps,
                    });
                });
            }
            return updatedState;
        },
        conversationRemoved(state, action) {
            const { payload: conversationId } = action;
            const { conversationLookup, selectedConversation } = state;
            return {
                ...state,
                conversationLookup: (0, lodash_1.omit)(conversationLookup, [conversationId]),
                selectedConversation: selectedConversation === conversationId ? undefined : selectedConversation,
            };
        },
        removeAllConversations() {
            return getEmptyConversationState();
        },
        messagesChanged(state, action) {
            return handleMessagesChangedOrAdded(state, action.payload);
        },
        messageExpired(state, action) {
            return handleMessageExpiredOrDeleted(state, action);
        },
        messageDeleted(state, action) {
            return handleMessageExpiredOrDeleted(state, action);
        },
        conversationReset(state, action) {
            return handleConversationReset(state, action);
        },
        markConversationFullyRead(state, action) {
            if (state.selectedConversation !== action.payload) {
                return state;
            }
            return {
                ...state,
                shouldHighlightMessage: false,
                firstUnreadMessageId: undefined,
            };
        },
        resetConversationExternal(state) {
            return { ...getEmptyConversationState(), conversationLookup: state.conversationLookup };
        },
        openConversationExternal(state, action) {
            if (state.selectedConversation === action.payload.conversationKey) {
                return state;
            }
            const messagesToConsiderForShowingUnreadBanner = 10;
            let showScrollButton = Boolean(action.payload.firstUnreadIdOnOpen);
            if (action.payload.initialMessages?.length <= messagesToConsiderForShowingUnreadBanner ||
                action.payload.initialMessages
                    ?.slice(0, messagesToConsiderForShowingUnreadBanner)
                    .some(n => n.propsForMessage.id === action.payload.firstUnreadIdOnOpen)) {
                showScrollButton = false;
            }
            return {
                conversationLookup: state.conversationLookup,
                mostRecentMessageId: action.payload.mostRecentMessageIdOnOpen,
                selectedConversation: action.payload.conversationKey,
                firstUnreadMessageId: action.payload.firstUnreadIdOnOpen,
                messages: action.payload.initialMessages,
                areMoreMessagesBeingFetched: false,
                showRightPanel: false,
                showShareContact: false,
                showViewContactPanel: null,
                selectedMessageIds: [],
                lightBox: undefined,
                messageDetailProps: undefined,
                quotedMessage: undefined,
                nextMessageToPlay: undefined,
                showScrollButton,
                animateQuotedMessageId: undefined,
                shouldHighlightMessage: false,
                oldTopMessageId: null,
                oldBottomMessageId: null,
                mentionMembers: [],
            };
        },
        openConversationToSpecificMessage(state, action) {
            return {
                ...state,
                selectedConversation: action.payload.conversationKey,
                mostRecentMessageIdOnOpen: action.payload.mostRecentMessageIdOnOpen,
                areMoreMessagesBeingFetched: false,
                messages: action.payload.initialMessages,
                showScrollButton: Boolean(action.payload.messageIdToNavigateTo !== action.payload.mostRecentMessageIdOnOpen),
                animateQuotedMessageId: action.payload.messageIdToNavigateTo,
                shouldHighlightMessage: action.payload.shouldHighlightMessage,
                oldTopMessageId: null,
                oldBottomMessageId: null,
            };
        },
        resetOldTopMessageId(state) {
            state.oldTopMessageId = null;
            return state;
        },
        resetOldBottomMessageId(state) {
            state.oldBottomMessageId = null;
            return state;
        },
        showLightBox(state, action) {
            state.lightBox = action.payload;
            return state;
        },
        showScrollToBottomButton(state, action) {
            state.showScrollButton = action.payload;
            return state;
        },
        quoteMessage(state, action) {
            state.quotedMessage = action.payload;
            return state;
        },
        quotedMessageToAnimate(state, action) {
            state.animateQuotedMessageId = action.payload;
            state.shouldHighlightMessage = Boolean(state.animateQuotedMessageId);
            return state;
        },
        setNextMessageToPlayId(state, action) {
            state.nextMessageToPlayId = action.payload;
            return state;
        },
        updateMentionsMembers(state, action) {
            window?.log?.info('updating mentions input members length', action.payload?.length);
            state.mentionMembers = action.payload;
            return state;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(exports.fetchTopMessagesForConversation.fulfilled, (state, action) => {
            if (!action.payload) {
                return { ...state, areMoreMessagesBeingFetched: false };
            }
            const { messagesProps, conversationKey, oldTopMessageId } = action.payload;
            if (conversationKey === state.selectedConversation) {
                return {
                    ...state,
                    oldTopMessageId,
                    messages: messagesProps,
                    areMoreMessagesBeingFetched: false,
                };
            }
            return state;
        });
        builder.addCase(exports.fetchTopMessagesForConversation.pending, (state) => {
            state.areMoreMessagesBeingFetched = true;
            return state;
        });
        builder.addCase(exports.fetchTopMessagesForConversation.rejected, (state) => {
            state.areMoreMessagesBeingFetched = false;
            return state;
        });
        builder.addCase(exports.fetchBottomMessagesForConversation.fulfilled, (state, action) => {
            if (!action.payload) {
                return { ...state, areMoreMessagesBeingFetched: false };
            }
            const { messagesProps, conversationKey, oldBottomMessageId, newMostRecentMessageIdInConversation, } = action.payload;
            if (conversationKey === state.selectedConversation) {
                return {
                    ...state,
                    oldBottomMessageId,
                    messages: messagesProps,
                    areMoreMessagesBeingFetched: false,
                    mostRecentMessageId: newMostRecentMessageIdInConversation,
                };
            }
            return state;
        });
        builder.addCase(exports.fetchBottomMessagesForConversation.pending, (state) => {
            state.areMoreMessagesBeingFetched = true;
            return state;
        });
        builder.addCase(exports.fetchBottomMessagesForConversation.rejected, (state) => {
            state.areMoreMessagesBeingFetched = false;
            return state;
        });
    },
});
function applyConversationChanged(state, payload) {
    const { id, data } = payload;
    const { conversationLookup, selectedConversation } = state;
    const existing = conversationLookup[id];
    if (!existing) {
        return state;
    }
    return {
        ...state,
        selectedConversation,
        conversationLookup: {
            ...conversationLookup,
            [id]: data,
        },
    };
}
exports.actions = conversationsSlice.actions, exports.reducer = conversationsSlice.reducer;
exports.conversationAdded = exports.actions.conversationAdded, exports.conversationChanged = exports.actions.conversationChanged, exports.conversationsChanged = exports.actions.conversationsChanged, exports.conversationRemoved = exports.actions.conversationRemoved, exports.removeAllConversations = exports.actions.removeAllConversations, exports.messageExpired = exports.actions.messageExpired, exports.messageDeleted = exports.actions.messageDeleted, exports.conversationReset = exports.actions.conversationReset, exports.messagesChanged = exports.actions.messagesChanged, exports.resetOldTopMessageId = exports.actions.resetOldTopMessageId, exports.resetOldBottomMessageId = exports.actions.resetOldBottomMessageId, exports.markConversationFullyRead = exports.actions.markConversationFullyRead, exports.showMessageDetailsView = exports.actions.showMessageDetailsView, exports.closeMessageDetailsView = exports.actions.closeMessageDetailsView, exports.openRightPanel = exports.actions.openRightPanel, exports.closeRightPanel = exports.actions.closeRightPanel, exports.addMessageIdToSelection = exports.actions.addMessageIdToSelection, exports.resetSelectedMessageIds = exports.actions.resetSelectedMessageIds, exports.toggleSelectedMessageId = exports.actions.toggleSelectedMessageId, exports.showLightBox = exports.actions.showLightBox, exports.quoteMessage = exports.actions.quoteMessage, exports.showScrollToBottomButton = exports.actions.showScrollToBottomButton, exports.quotedMessageToAnimate = exports.actions.quotedMessageToAnimate, exports.setNextMessageToPlayId = exports.actions.setNextMessageToPlayId, exports.updateMentionsMembers = exports.actions.updateMentionsMembers, exports.resetConversationExternal = exports.actions.resetConversationExternal, exports.openShareContact = exports.actions.openShareContact, exports.closeShareContact = exports.actions.closeShareContact, exports.updateViewContactPanel = exports.actions.updateViewContactPanel;
async function openConversationWithMessages(args) {
    const { conversationKey, messageId, bns } = args;
    const firstUnreadIdOnOpen = await (0, data_1.getFirstUnreadMessageIdInConversation)(conversationKey);
    const mostRecentMessageIdOnOpen = await (0, data_1.getLastMessageIdInConversation)(conversationKey);
    if (bns) {
        savebnsname(conversationKey, bns);
    }
    const initialMessages = await getMessages({
        conversationKey,
        messageId: messageId || null,
    });
    window.inboxStore?.dispatch(exports.actions.openConversationExternal({
        conversationKey,
        firstUnreadIdOnOpen,
        mostRecentMessageIdOnOpen,
        initialMessages,
    }));
}
exports.openConversationWithMessages = openConversationWithMessages;
const savebnsname = async (conversationKey, displayName) => {
    if (!conversationKey) {
        throw new Error('Cant save without conversation id');
    }
    const conversation = await (0, conversations_1.getConversationController)().get(conversationKey);
    if (conversation.getBchatProfile()?.displayName) {
        return;
    }
    await conversation.setBchatProfile({ displayName });
};
async function openConversationToSpecificMessage(args) {
    const { conversationKey, messageIdToNavigateTo, shouldHighlightMessage } = args;
    const messagesAroundThisMessage = await getMessages({
        conversationKey,
        messageId: messageIdToNavigateTo,
    });
    const mostRecentMessageIdOnOpen = await (0, data_1.getLastMessageIdInConversation)(conversationKey);
    window.inboxStore?.dispatch(exports.actions.openConversationToSpecificMessage({
        conversationKey,
        messageIdToNavigateTo,
        mostRecentMessageIdOnOpen,
        shouldHighlightMessage,
        initialMessages: messagesAroundThisMessage,
    }));
}
exports.openConversationToSpecificMessage = openConversationToSpecificMessage;
