"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reducer = exports.initialSectionState = exports.actions = exports.showSettingsSection = exports.setOverlayMode = exports.setIsAppFocused = exports.showLeftPaneSection = exports.SectionType = exports.OVERLAY_MODE = exports.IS_APP_FOCUSED = exports.FOCUS_SETTINGS_SECTION = exports.FOCUS_SECTION = void 0;
const BchatSettings_1 = require("../../components/settings/BchatSettings");
exports.FOCUS_SECTION = 'FOCUS_SECTION';
exports.FOCUS_SETTINGS_SECTION = 'FOCUS_SETTINGS_SECTION';
exports.IS_APP_FOCUSED = 'IS_APP_FOCUSED';
exports.OVERLAY_MODE = 'OVERLAY_MODE';
var SectionType;
(function (SectionType) {
    SectionType[SectionType["Message"] = 0] = "Message";
    SectionType[SectionType["NewChat"] = 1] = "NewChat";
    SectionType[SectionType["Closedgroup"] = 2] = "Closedgroup";
    SectionType[SectionType["Opengroup"] = 3] = "Opengroup";
    SectionType[SectionType["Wallet"] = 4] = "Wallet";
    SectionType[SectionType["Settings"] = 5] = "Settings";
    SectionType[SectionType["Profile"] = 6] = "Profile";
    SectionType[SectionType["Contact"] = 7] = "Contact";
    SectionType[SectionType["Moon"] = 8] = "Moon";
    SectionType[SectionType["PathIndicator"] = 9] = "PathIndicator";
    SectionType[SectionType["SubMenu"] = 10] = "SubMenu";
    SectionType[SectionType["CallHistory"] = 11] = "CallHistory";
})(SectionType = exports.SectionType || (exports.SectionType = {}));
function showLeftPaneSection(section) {
    return {
        type: exports.FOCUS_SECTION,
        payload: section,
    };
}
exports.showLeftPaneSection = showLeftPaneSection;
function setIsAppFocused(focused) {
    return {
        type: exports.IS_APP_FOCUSED,
        payload: focused,
    };
}
exports.setIsAppFocused = setIsAppFocused;
function setOverlayMode(overlayMode) {
    return {
        type: exports.OVERLAY_MODE,
        payload: overlayMode,
    };
}
exports.setOverlayMode = setOverlayMode;
function showSettingsSection(category) {
    return {
        type: exports.FOCUS_SETTINGS_SECTION,
        payload: category,
    };
}
exports.showSettingsSection = showSettingsSection;
exports.actions = {
    showLeftPaneSection,
    showSettingsSection,
    setOverlayMode,
};
exports.initialSectionState = {
    focusedSection: SectionType.Message,
    focusedSettingsSection: undefined,
    isAppFocused: false,
    overlayMode: undefined,
};
const reducer = (state = exports.initialSectionState, { type, payload, }) => {
    switch (type) {
        case exports.FOCUS_SECTION:
            const castedPayload = payload;
            if (castedPayload !== SectionType.Settings) {
                return {
                    ...state,
                    focusedSection: castedPayload,
                    focusedSettingsSection: undefined,
                };
            }
            return {
                ...state,
                focusedSection: payload,
                focusedSettingsSection: BchatSettings_1.BchatSettingCategory.Chat,
            };
        case exports.FOCUS_SETTINGS_SECTION:
            return {
                ...state,
                focusedSettingsSection: payload,
            };
        case exports.IS_APP_FOCUSED:
            return {
                ...state,
                isAppFocused: payload,
            };
        case exports.OVERLAY_MODE:
            return {
                ...state,
                overlayMode: payload,
            };
        default:
            return state;
    }
};
exports.reducer = reducer;
