"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userConfigReducer = exports.updateIsCurrentlyRecording = exports.toggleMultipleSelection = exports.hideMultipleSelection = exports.hideMessageRequestBanner = exports.showMessageRequestBanner = exports.toggleMessageRequests = exports.disableRecoveryPhrasePrompt = exports.toggleAudioAutoplay = exports.initialUserConfigState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
exports.initialUserConfigState = {
    audioAutoplay: false,
    showRecoveryPhrasePrompt: true,
    hideMessageRequests: false,
    multipleSelection: false,
    isCurrentlyRecording: false,
};
const userConfigSlice = (0, toolkit_1.createSlice)({
    name: 'userConfig',
    initialState: exports.initialUserConfigState,
    reducers: {
        toggleAudioAutoplay: state => {
            state.audioAutoplay = !state.audioAutoplay;
        },
        disableRecoveryPhrasePrompt: state => {
            state.showRecoveryPhrasePrompt = false;
        },
        toggleMessageRequests: state => {
            state.hideMessageRequests = !state.hideMessageRequests;
        },
        showMessageRequestBanner: state => {
            state.hideMessageRequests = false;
        },
        hideMessageRequestBanner: state => {
            state.hideMessageRequests = true;
        },
        hideMultipleSelection: state => {
            state.multipleSelection = false;
        },
        toggleMultipleSelection: state => {
            state.multipleSelection = !state.multipleSelection;
        },
        updateIsCurrentlyRecording: (state, action) => {
            state.isCurrentlyRecording = action.payload;
        }
    },
});
const { actions, reducer } = userConfigSlice;
exports.toggleAudioAutoplay = actions.toggleAudioAutoplay, exports.disableRecoveryPhrasePrompt = actions.disableRecoveryPhrasePrompt, exports.toggleMessageRequests = actions.toggleMessageRequests, exports.showMessageRequestBanner = actions.showMessageRequestBanner, exports.hideMessageRequestBanner = actions.hideMessageRequestBanner, exports.hideMultipleSelection = actions.hideMultipleSelection, exports.toggleMultipleSelection = actions.toggleMultipleSelection, exports.updateIsCurrentlyRecording = actions.updateIsCurrentlyRecording;
exports.userConfigReducer = reducer;
