"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rootReducer = exports.reducers = void 0;
const redux_1 = require("redux");
const search_1 = require("./ducks/search");
const conversations_1 = require("./ducks/conversations");
const user_1 = require("./ducks/user");
const theme_1 = require("./ducks/theme");
const bnsConfig_1 = require("./ducks/bnsConfig");
const walletSection_1 = require("./ducks/walletSection");
const walletInnerSection_1 = require("./ducks/walletInnerSection");
const section_1 = require("./ducks/section");
const defaultRooms_1 = require("./ducks/defaultRooms");
const call_1 = require("./ducks/call");
const onion_1 = require("./ducks/onion");
const modalDialog_1 = require("./ducks/modalDialog");
const userConfig_1 = require("./ducks/userConfig");
const timerOptions_1 = require("./ducks/timerOptions");
const stagedAttachments_1 = require("./ducks/stagedAttachments");
const wallet_1 = require("./ducks/wallet");
const daemon_1 = require("./ducks/daemon");
const walletConfig_1 = require("./ducks/walletConfig");
const callHistory_1 = require("./ducks//callHistory");
exports.reducers = {
    search: search_1.reducer,
    conversations: conversations_1.reducer,
    user: user_1.reducer,
    wallet: wallet_1.reducer,
    daemon: daemon_1.reducer,
    theme: theme_1.reducer,
    isVerifyBnsCalled: bnsConfig_1.reducer,
    section: section_1.reducer,
    defaultRooms: defaultRooms_1.defaultRoomReducer,
    onionPaths: onion_1.defaultOnionReducer,
    modals: modalDialog_1.modalReducer,
    userConfig: userConfig_1.userConfigReducer,
    timerOptions: timerOptions_1.timerOptionReducer,
    stagedAttachments: stagedAttachments_1.reducer,
    call: call_1.callReducer,
    walletFocused: walletSection_1.reducer,
    walletInnerFocused: walletInnerSection_1.reducer,
    walletConfig: walletConfig_1.reducer,
    callHistory: callHistory_1.reducer
};
exports.rootReducer = (0, redux_1.combineReducers)(exports.reducers);
