"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStagedAttachmentsForCurrentConversation = exports.getStagedAttachmentsState = void 0;
const reselect_1 = require("reselect");
const conversations_1 = require("./conversations");
const getStagedAttachmentsState = (state) => state.stagedAttachments;
exports.getStagedAttachmentsState = getStagedAttachmentsState;
const getStagedAttachmentsForConversation = (state, conversationKey) => {
    if (!conversationKey) {
        return undefined;
    }
    return state.stagedAttachments[conversationKey] || [];
};
exports.getStagedAttachmentsForCurrentConversation = (0, reselect_1.createSelector)([conversations_1.getSelectedConversationKey, exports.getStagedAttachmentsState], (selectedConversationKey, state) => {
    return getStagedAttachmentsForConversation(state, selectedConversationKey);
});
