"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const new_user_1 = require("./setup/new_user");
const open_1 = require("./setup/open");
const Promise_1 = require("../../bchat/utils/Promise");
const beforeEach_1 = require("./setup/beforeEach");
const utils_1 = require("./utils");
let window;
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
test_1.test.afterEach(async () => {
    if (window) {
        await (0, beforeEach_1.forceCloseAllWindows)([window]);
    }
});
(0, test_1.test)('Create User', async () => {
    window = await (0, open_1.openAppAndWait)('1');
    const userA = await (0, new_user_1.newUser)(window, 'userA');
    await (0, utils_1.clickOnTestIdWithText)(window, 'leftpane-primary-avatar');
    await (0, Promise_1.sleepFor)(100, true);
    await (0, utils_1.waitForTestIdWithText)(window, 'your-profile-name', userA.userName);
    await (0, utils_1.waitForTestIdWithText)(window, 'your-bchat-id', userA.bchatid);
    await window.click('.bchat-icon-button.small');
    await (0, utils_1.clickOnTestIdWithText)(window, 'settings-section');
    await (0, utils_1.clickOnMatchingText)(window, 'Recovery Phrase');
    await (0, utils_1.waitForTestIdWithText)(window, 'recovery-phrase-seed-modal', userA.recoveryPhrase);
    await window.click('.bchat-icon-button.small');
});
