"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const log_in_1 = require("./setup/log_in");
const test_user_1 = require("./setup/test_user");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
test_1.test.skip('Group upkeep', async () => {
    const [windowA, windowB, windowC, windowD, windowE] = await (0, new_user_1.openAppsNoNewUsers)(5);
    windows = [windowA, windowB, windowC, windowD, windowE];
    await Promise.all([
        (0, log_in_1.logIn)(windowA, test_user_1.testUser.recoveryPhrase),
        (0, log_in_1.logIn)(windowB, test_user_1.testContactOne.recoveryPhrase),
        (0, log_in_1.logIn)(windowC, test_user_1.testContactTwo.recoveryPhrase),
        (0, log_in_1.logIn)(windowD, test_user_1.testContactThree.recoveryPhrase),
        (0, log_in_1.logIn)(windowE, test_user_1.testContactFour.recoveryPhrase),
    ]);
    await (0, send_message_1.sendNewMessage)(windowA, test_user_1.testContactOne.bchatid, `Test user -> Whale (TC1): ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowB, test_user_1.testUser.bchatid, `Whale (TC1) -> Test user : ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowA, test_user_1.testContactTwo.bchatid, `Test user -> Dragon (TC2): ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowC, test_user_1.testUser.bchatid, `Dragon (TC2) -> Test user : ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowA, test_user_1.testContactThree.bchatid, `Test user -> Fish (TC3): ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowD, test_user_1.testUser.bchatid, `Fish (TC3) -> Test user : ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowA, test_user_1.testContactFour.bchatid, `Test user -> Gopher (TC4): ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowE, test_user_1.testUser.bchatid, `Gopher (TC4) -> Test user : ${Date.now()}`);
});
