"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const utils_1 = require("./utils");
const create_group_1 = require("./setup/create_group");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Mentions', async () => {
    const { userA, userB, userC, windowA, windowB, windowC } = await (0, create_group_1.createGroup)('Test Group Name');
    windows = [windowA, windowB, windowC];
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'module-conversation__user__profile-name', 'Test Group Name');
    await (0, utils_1.typeIntoInput)(windowA, 'message-input-text-area', '@');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'mentions-popup-row');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'mentions-popup-row', userB.userName);
    await (0, utils_1.waitForTestIdWithText)(windowA, 'mentions-popup-row', userC.userName);
    await (0, utils_1.clickOnTestIdWithText)(windowB, 'module-conversation__user__profile-name', 'Test Group Name');
    await (0, utils_1.typeIntoInput)(windowB, 'message-input-text-area', '@');
    await (0, utils_1.waitForTestIdWithText)(windowB, 'mentions-popup-row');
    await (0, utils_1.waitForTestIdWithText)(windowB, 'mentions-popup-row', userA.userName);
    await (0, utils_1.waitForTestIdWithText)(windowB, 'mentions-popup-row', userC.userName);
    await (0, utils_1.clickOnTestIdWithText)(windowC, 'module-conversation__user__profile-name', 'Test Group Name');
    await (0, utils_1.typeIntoInput)(windowC, 'message-input-text-area', '@');
    await (0, utils_1.waitForTestIdWithText)(windowC, 'mentions-popup-row');
    await (0, utils_1.waitForTestIdWithText)(windowC, 'mentions-popup-row', userA.userName);
    await (0, utils_1.waitForTestIdWithText)(windowC, 'mentions-popup-row', userB.userName);
});
