"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.messageSent = void 0;
const utils_1 = require("./utils");
const messageSent = async (window, message) => {
    await (0, utils_1.typeIntoInput)(window, 'message-input-text-area', message);
    await (0, utils_1.clickOnTestIdWithText)(window, 'send-message-button');
    const selc = `css=[data-testid=readable-message]:has-text("${message}"):has([data-testid=msg-status-outgoing][data-testtype=sent])`;
    console.warn('waiting for sent tick of message: ', message);
    const tickMessageSent = await window.waitForSelector(selc, { timeout: 30000 });
    console.warn('found the tick of message sent: ', message, Boolean(tickMessageSent));
};
exports.messageSent = messageSent;
