"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forceCloseAllWindows = exports.cleanUpOtherTest = void 0;
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const open_1 = require("./open");
const getDirectoriesOfBchatDataPath = (source) => (0, fs_extra_1.readdirSync)(source, { withFileTypes: true })
    .filter(dirent => dirent.isDirectory())
    .map(dirent => dirent.name)
    .filter(n => n.startsWith(`Bchat-${open_1.NODE_ENV}-${open_1.MULTI_PREFIX}`));
const cleanUpOtherTest = async () => {
    const electronApp = await (0, open_1.openElectronAppOnly)('start');
    const appPath = await electronApp.evaluate(async ({ app }) => {
        return app.getPath('userData');
    });
    const window = await electronApp.firstWindow();
    await window.close();
    if (!appPath.length) {
        throw new Error('appDataPath unset');
    }
    const parentFolderOfAllDataPath = (0, path_1.dirname)(appPath);
    if (!parentFolderOfAllDataPath || parentFolderOfAllDataPath.length < 20) {
        throw new Error('parentFolderOfAllDataPath not found or invalid');
    }
    const allAppDataPath = getDirectoriesOfBchatDataPath(parentFolderOfAllDataPath);
    allAppDataPath.map(folder => {
        if (!appPath) {
            throw new Error('parentFolderOfAllDataPath unset');
        }
        const pathToRemove = (0, path_1.join)(parentFolderOfAllDataPath, folder);
        (0, fs_extra_1.rmdirSync)(pathToRemove, { recursive: true });
    });
};
exports.cleanUpOtherTest = cleanUpOtherTest;
const forceCloseAllWindows = async (windows) => {
    return Promise.all(windows.map(w => w.close()));
};
exports.forceCloseAllWindows = forceCloseAllWindows;
