"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGroup = void 0;
const message_1 = require("../message");
const new_user_1 = require("../setup/new_user");
const send_message_1 = require("../send_message");
const utils_1 = require("../utils");
let windows = [];
const createGroup = async (groupName) => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(3);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB, windowC] = windows;
    const [userA, userB, userC] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userC.bchatid, `A -> C: ${Date.now()}`);
    await Promise.all([
        (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `A -> B: ${Date.now()}`),
        (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, `B -> A: ${Date.now()}`),
        (0, send_message_1.sendNewMessage)(windowC, userA.bchatid, `C -> A: ${Date.now()}`),
    ]);
    await (0, utils_1.clickOnTestIdWithText)(windowC, 'messages-container');
    await (0, utils_1.clickOnMatchingText)(windowA, 'New Closed Group');
    await (0, utils_1.typeIntoInput)(windowA, 'new-closed-group-name', groupName);
    await (0, utils_1.clickOnMatchingText)(windowA, userB.userName);
    await (0, utils_1.clickOnMatchingText)(windowA, userC.userName);
    await (0, utils_1.clickOnMatchingText)(windowA, 'Done');
    await (0, utils_1.clickOnMatchingText)(windowB, groupName);
    await (0, utils_1.waitForTestIdWithText)(windowB, 'header-conversation-name', groupName);
    const msgAToGroup = 'A -> Group';
    await (0, message_1.messageSent)(windowA, msgAToGroup);
    await (0, utils_1.clickOnMatchingText)(windowA, msgAToGroup);
    await (0, utils_1.clickOnTestIdWithText)(windowB, 'message-section');
    await (0, utils_1.clickOnMatchingText)(windowB, groupName);
    await (0, utils_1.waitForReadableMessageWithText)(windowB, msgAToGroup);
    const msgBToGroup = 'B -> Group';
    await (0, message_1.messageSent)(windowB, msgBToGroup);
    await (0, utils_1.clickOnMatchingText)(windowB, msgBToGroup);
    await (0, utils_1.clickOnTestIdWithText)(windowC, 'message-section');
    await (0, utils_1.clickOnMatchingText)(windowC, groupName);
    await (0, utils_1.waitForReadableMessageWithText)(windowC, msgAToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowC, msgBToGroup);
    const msgCToGroup = 'C -> Group';
    await (0, message_1.messageSent)(windowC, msgCToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowA, msgBToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowA, msgCToGroup);
    return { userA, userB, windowA, windowB, userC, windowC };
};
exports.createGroup = createGroup;
