"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.existingUser = exports.openAppsNoNewUsers = exports.openAppsAndNewUsers = exports.newUser = void 0;
const lodash_1 = __importDefault(require("lodash"));
const utils_1 = require("../utils");
const open_1 = require("./open");
const multisAvailable = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
const newUser = async (window, userName) => {
    await (0, utils_1.clickOnMatchingText)(window, 'Create Account');
    await window.waitForTimeout(1500);
    const bchatid = await window.inputValue('[data-testid=bchat-id-signup]');
    await (0, utils_1.clickOnMatchingText)(window, 'Continue');
    await (0, utils_1.typeIntoInput)(window, 'display-name-input', userName);
    await (0, utils_1.clickOnMatchingText)(window, 'Get started');
    await (0, utils_1.clickOnMatchingText)(window, 'Reveal Recovery Phrase');
    const recoveryPhrase = await window.innerText('[data-testid=recovery-phrase-seed-modal]');
    await window.click('.bchat-icon-button.small');
    return { userName, bchatid, recoveryPhrase };
};
exports.newUser = newUser;
const openAppAndNewUser = async (multi) => {
    const window = await (0, open_1.openAppAndWait)(multi);
    const userName = `${multi}-user`;
    const loggedIn = await (0, exports.newUser)(window, userName);
    return { window, ...loggedIn };
};
async function openAppsAndNewUsers(windowToCreate) {
    if (windowToCreate >= multisAvailable.length) {
        throw new Error(`Do you really need ${multisAvailable.length} windows?!`);
    }
    const multisToUse = multisAvailable.slice(0, windowToCreate);
    const loggedInDetails = await Promise.all([...multisToUse].map(async (m) => {
        return openAppAndNewUser(m);
    }));
    const windows = loggedInDetails.map(w => w.window);
    const users = loggedInDetails.map(w => {
        return lodash_1.default.pick(w, ['bchatid', 'recoveryPhrase', 'userName']);
    });
    return { windows, users };
}
exports.openAppsAndNewUsers = openAppsAndNewUsers;
async function openAppsNoNewUsers(windowToCreate) {
    if (windowToCreate >= multisAvailable.length) {
        throw new Error(`Do you really need ${multisAvailable.length} windows?!`);
    }
    const multisToUse = multisAvailable.slice(0, windowToCreate);
    return Promise.all([...multisToUse].map(async (m) => {
        return (0, open_1.openAppAndWait)(m);
    }));
}
exports.openAppsNoNewUsers = openAppsNoNewUsers;
async function existingUser() {
    const recoveryPhraseTest = 'pinched total ongoing sushi etched rest gone long oilfield incur code grunt code';
    const newUsername = 'new-username';
    const [windowA1] = await openAppsNoNewUsers(1);
    await (0, utils_1.clickOnTestIdWithText)(windowA1, 'restore-using-recovery');
    await (0, utils_1.typeIntoInput)(windowA1, 'recovery-phrase-input', recoveryPhraseTest);
    await (0, utils_1.typeIntoInput)(windowA1, 'display-name-input', newUsername);
    await (0, utils_1.clickOnTestIdWithText)(windowA1, 'continue-bchat-button');
    return existingUser;
}
exports.existingUser = existingUser;
