"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.openAppAndWait = exports.openElectronAppOnly = exports.MULTI_PREFIX = exports.NODE_ENV = void 0;
const test_1 = require("@playwright/test");
const path_1 = require("path");
const getRootPath_1 = require("../../../node/getRootPath");
exports.NODE_ENV = 'production';
exports.MULTI_PREFIX = 'test-integration-testnet-';
const openElectronAppOnly = async (multi) => {
    process.env.NODE_APP_INSTANCE = `${exports.MULTI_PREFIX}-${multi}`;
    process.env.NODE_ENV = exports.NODE_ENV;
    const electronApp = await test_1._electron.launch({
        args: [(0, path_1.join)((0, getRootPath_1.getAppRootPath)(), 'ts', 'mains', 'main_node.js')],
    });
    return electronApp;
};
exports.openElectronAppOnly = openElectronAppOnly;
const openAppAndWait = async (multi) => {
    const electronApp = await (0, exports.openElectronAppOnly)(multi);
    const window = await electronApp.firstWindow();
    return window;
};
exports.openAppAndWait = openAppAndWait;
