"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const utils_1 = require("./utils");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Switch themes', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(1);
    windows = windowLoggedIn.windows;
    const [windowA] = windows;
    const lightThemeColor = windowA.locator('.inbox.index');
    await (0, test_1.expect)(lightThemeColor).toHaveCSS('background-color', 'rgb(255, 255, 255)');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'theme-section');
    const darkThemeColor = windowA.locator('.inbox.index');
    await (0, test_1.expect)(darkThemeColor).toHaveCSS('background-color', 'rgb(23, 23, 23)');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'theme-section');
    await (0, test_1.expect)(lightThemeColor).toHaveCSS('background-color', 'rgb(255, 255, 255)');
});
