"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const utils_1 = require("./utils");
const testMessage = 'A -> B: ';
const testReply = 'B -> A: ';
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Unsend message', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB] = windows;
    const [userA, userB] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `${testMessage}${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, `${testReply}${Date.now()}`);
    await windowA.click('.module-message.module-message--outgoing', { button: 'right' });
    await (0, utils_1.clickOnMatchingText)(windowA, 'Delete for everyone');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'bchat-confirm-ok-button', 'Delete for everyone');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'bchat-toast', 'Deleted');
    await (0, utils_1.waitForMatchingText)(windowB, 'This message has been deleted');
});
