"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const mocha_1 = require("mocha");
const sinon_1 = __importDefault(require("sinon"));
const DecryptedAttachmentsManager = __importStar(require("../../../../bchat/crypto/DecryptedAttachmentsManager"));
const test_utils_1 = require("../../../test-utils");
describe('DecryptedAttachmentsManager', () => {
    (0, mocha_1.beforeEach)(() => {
        DecryptedAttachmentsManager.resetDecryptedUrlForTesting();
        test_utils_1.TestUtils.stubWindowLog();
        sinon_1.default.stub(DecryptedAttachmentsManager, 'getLocalAttachmentPath').returns('/local/attachment');
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
    describe('getAlreadyDecryptedMediaUrl', () => {
        describe('invalid url', () => {
            it('url is null', () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl(null)).to.be.null;
            });
            it('url is undefined', () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl(undefined)).to.be
                    .null;
            });
            it('url is empty string', () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('')).to.be.null;
            });
            it('url starts with something not being the attachment path', () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('/local/notvalid')).to.be
                    .null;
            });
        });
        it('url starts with "blob:" => returns the already decrypted url right away', () => {
            (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('blob:whatever')).to.be.eq('blob:whatever');
        });
        describe('url starts with attachmentPath', () => {
            let readFileContent;
            let getItemById;
            let decryptAttachmentBufferNode;
            (0, mocha_1.beforeEach)(() => {
                readFileContent = sinon_1.default.stub(DecryptedAttachmentsManager, 'readFileContent').resolves(Buffer.from('this is a test'));
                getItemById = test_utils_1.TestUtils.stubDataItem('getItemById')
                    .withArgs('local_attachment_encrypted_key')
                    .callsFake(async () => {
                    return { value: 'dfdf' };
                });
                decryptAttachmentBufferNode = test_utils_1.TestUtils.stubUtilWorker('decryptAttachmentBufferNode', new Uint8Array(5));
                test_utils_1.TestUtils.stubCreateObjectUrl();
            });
            it('url starts with attachment path but is not already decrypted', () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('/local/attachment/attachment1')).to.be.eq(null);
            });
            it('url starts with attachment path but is not already decrypted', async () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('/local/attachment/attachment1')).to.be.eq(null);
                (0, chai_1.expect)(readFileContent.callCount).to.be.eq(0);
                (0, chai_1.expect)(decryptAttachmentBufferNode.callCount).to.be.eq(0);
                (0, chai_1.expect)(getItemById.callCount).to.be.eq(0);
                const resolved = await DecryptedAttachmentsManager.getDecryptedMediaUrl('/local/attachment/attachment1', 'image/jpeg', false);
                (0, chai_1.expect)(readFileContent.callCount).to.be.eq(1);
                (0, chai_1.expect)(decryptAttachmentBufferNode.callCount).to.be.eq(1);
                (0, chai_1.expect)(getItemById.callCount).to.be.eq(1);
                const now = `${Date.now()}`;
                (0, chai_1.expect)(resolved).to.be.not.empty;
                (0, chai_1.expect)(resolved.startsWith(now.slice(0, 9))).to.be.true;
            });
            it('url starts with attachment path and is already decrypted', async () => {
                (0, chai_1.expect)(DecryptedAttachmentsManager.getAlreadyDecryptedMediaUrl('/local/attachment/attachment1')).to.be.eq(null);
                (0, chai_1.expect)(readFileContent.callCount).to.be.eq(0);
                (0, chai_1.expect)(decryptAttachmentBufferNode.callCount).to.be.eq(0);
                (0, chai_1.expect)(getItemById.callCount).to.be.eq(0);
                const resolved = await DecryptedAttachmentsManager.getDecryptedMediaUrl('/local/attachment/attachment1', 'image/jpeg', false);
                (0, chai_1.expect)(readFileContent.callCount).to.be.eq(1);
                (0, chai_1.expect)(decryptAttachmentBufferNode.callCount).to.be.eq(1);
                (0, chai_1.expect)(getItemById.callCount).to.be.eq(1);
                const now = `${Date.now()}`;
                (0, chai_1.expect)(resolved).to.be.not.empty;
                (0, chai_1.expect)(resolved.startsWith(now.slice(0, 9))).to.be.true;
                const resolved2 = await DecryptedAttachmentsManager.getDecryptedMediaUrl('/local/attachment/attachment1', 'image/jpeg', false);
                (0, chai_1.expect)(readFileContent.callCount).to.be.eq(1);
                (0, chai_1.expect)(decryptAttachmentBufferNode.callCount).to.be.eq(1);
                (0, chai_1.expect)(getItemById.callCount).to.be.eq(1);
                const now2 = `${Date.now()}`;
                (0, chai_1.expect)(resolved2).to.be.not.empty;
                (0, chai_1.expect)(resolved2.startsWith(now2.slice(0, 9))).to.be.true;
            });
        });
    });
    it.skip('cleanUpOldDecryptedMedias', () => { });
    it.skip('getDecryptedBlob', () => { });
});
