"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const mocha_1 = require("mocha");
const protobuf_1 = require("../../../../protobuf");
const bchat_1 = require("../../../../bchat");
const GroupInvitationMessage_1 = require("../../../../bchat/messages/outgoing/visibleMessage/GroupInvitationMessage");
describe('GroupInvitationMessage', () => {
    let message;
    const timestamp = Date.now();
    const url = 'http://localhost';
    const name = 'test';
    (0, mocha_1.beforeEach)(() => {
        message = new GroupInvitationMessage_1.GroupInvitationMessage({
            timestamp,
            url,
            name,
        });
    });
    it('dataMessage.groupInvitation has url, and serverName set', () => {
        const plainText = message.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        (0, chai_1.expect)(decoded.dataMessage?.openGroupInvitation).to.have.property('url', url);
        (0, chai_1.expect)(decoded.dataMessage?.openGroupInvitation).to.have.property('name', name);
    });
    it('correct ttl', () => {
        (0, chai_1.expect)(message.ttl()).to.equal(bchat_1.Constants.TTL_DEFAULT.TTL_MAX);
    });
    it('has an identifier', () => {
        (0, chai_1.expect)(message.identifier).to.not.equal(null, 'identifier cannot be null');
        (0, chai_1.expect)(message.identifier).to.not.equal(undefined, 'identifier cannot be undefined');
    });
});
