"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const mocha_1 = require("mocha");
const test_utils_1 = require("../../../test-utils");
const snode_api_1 = require("../../../../bchat/apis/snode_api");
const Data = __importStar(require("../../../../data/data"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const OnionPaths = __importStar(require("../../../../bchat/onions/onionPath"));
const utils_1 = require("../../../test-utils/utils");
const seed_node_api_1 = require("../../../../bchat/apis/seed_node_api");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
const guard1ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534e';
const guard2ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f91615349';
const guard3ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534a';
const fakeSnodePool = [
    ...(0, utils_1.generateFakeSnodes)(12),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard1ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard2ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard3ed),
    ...(0, utils_1.generateFakeSnodes)(3),
];
(0, mocha_1.describe)('GuardNodes', () => {
    let getSnodePoolFromDBOrFetchFromSeed;
    let fetchFromSeedWithRetriesAndWriteToDb;
    (0, mocha_1.describe)('selectGuardNodes', () => {
        beforeEach(() => {
            OnionPaths.clearTestOnionPath();
            test_utils_1.TestUtils.stubWindowLog();
            test_utils_1.TestUtils.stubWindow('getGlobalOnlineStatus', () => true);
            snode_api_1.Onions.resetSnodeFailureCount();
            OnionPaths.resetPathFailureCount();
            snode_api_1.SnodePool.TEST_resetState();
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        it('does not fetch from seed if we got 12 or more snodes in the db', async () => {
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(fakeSnodePool);
            getSnodePoolFromDBOrFetchFromSeed = sinon_1.default.stub(snode_api_1.SnodePool, 'getSnodePoolFromDBOrFetchFromSeed').callThrough();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(snode_api_1.SnodePool, 'TEST_fetchFromSeedWithRetriesAndWriteToDb').resolves();
            const testGuardNode = sinon_1.default.stub(OnionPaths, 'testGuardNode').resolves(true);
            sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
            const fetchedGuardNodes = await OnionPaths.selectGuardNodes();
            expect(getSnodePoolFromDBOrFetchFromSeed.callCount, 'getSnodePoolFromDBOrFetchFromSeed should have been called').to.be.eq(1);
            expect(fetchFromSeedWithRetriesAndWriteToDb.callCount, 'fetchFromSeedWithRetriesAndWriteToDb should not have been called').to.be.eq(0);
            expect(testGuardNode.callCount, 'firstGuardNode should have been called three times').to.be.eq(3);
            const firstGuardNode = testGuardNode.firstCall.args[0];
            const secondGuardNode = testGuardNode.secondCall.args[0];
            const thirdGuardNode = testGuardNode.thirdCall.args[0];
            expect(fetchedGuardNodes).to.deep.equal([firstGuardNode, secondGuardNode, thirdGuardNode]);
        });
        it('throws an error if we got enough snodes in the db but none test passes', async () => {
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(fakeSnodePool);
            getSnodePoolFromDBOrFetchFromSeed = sinon_1.default.stub(snode_api_1.SnodePool, 'getSnodePoolFromDBOrFetchFromSeed').callThrough();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(snode_api_1.SnodePool, 'TEST_fetchFromSeedWithRetriesAndWriteToDb').resolves();
            const testGuardNode = sinon_1.default.stub(OnionPaths, 'testGuardNode').resolves(false);
            sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
            let throwedError;
            try {
                await OnionPaths.selectGuardNodes();
            }
            catch (e) {
                throwedError = e.message;
            }
            expect(getSnodePoolFromDBOrFetchFromSeed.callCount, 'getSnodePoolFromDBOrFetchFromSeed should have been called').to.be.eq(1);
            expect(fetchFromSeedWithRetriesAndWriteToDb.callCount, 'fetchFromSeedWithRetriesAndWriteToDb should not have been called').to.be.eq(0);
            expect(testGuardNode.callCount, 'firstGuardNode should have been called three times').to.be.eq(18);
            expect(throwedError).to.be.equal('selectGuardNodes stopping after attempts: 6');
        });
        it('throws an error if we have to fetch from seed, fetch from seed enough snode but we still fail', async () => {
            const invalidSndodePool = fakeSnodePool.slice(0, 11);
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(invalidSndodePool);
            test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => [{ url: 'whatever' }]);
            getSnodePoolFromDBOrFetchFromSeed = sinon_1.default.stub(snode_api_1.SnodePool, 'getSnodePoolFromDBOrFetchFromSeed').callThrough();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(fakeSnodePool);
            sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
            let throwedError;
            try {
                await OnionPaths.selectGuardNodes();
            }
            catch (e) {
                throwedError = e.message;
            }
            expect(throwedError).to.be.equal('selectGuardNodes stopping after attempts: 6');
        });
        it('returns valid guardnode if we have to fetch from seed, fetch from seed enough snodes but guard node tests passes', async () => {
            const invalidSndodePool = fakeSnodePool.slice(0, 11);
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(invalidSndodePool);
            test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => [{ url: 'whatever' }]);
            const testGuardNode = sinon_1.default.stub(OnionPaths, 'testGuardNode').resolves(true);
            getSnodePoolFromDBOrFetchFromSeed = sinon_1.default.stub(snode_api_1.SnodePool, 'getSnodePoolFromDBOrFetchFromSeed').callThrough();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(fakeSnodePool);
            sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
            const guardNodes = await OnionPaths.selectGuardNodes();
            expect(guardNodes.length).to.be.equal(3);
            expect(testGuardNode.callCount).to.be.equal(3);
        });
        it('throws if we have to fetch from seed, fetch from seed but not have enough fetched snodes', async () => {
            const invalidSndodePool = fakeSnodePool.slice(0, 11);
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(invalidSndodePool);
            test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => [{ url: 'whatever' }]);
            getSnodePoolFromDBOrFetchFromSeed = sinon_1.default.stub(snode_api_1.SnodePool, 'getSnodePoolFromDBOrFetchFromSeed').callThrough();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(invalidSndodePool);
            sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
            let throwedError;
            try {
                await OnionPaths.selectGuardNodes();
            }
            catch (e) {
                throwedError = e.message;
            }
            expect(throwedError).to.be.equal('Could not select guard nodes. Not enough nodes in the pool: 11');
        });
    });
});
