"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const mocha_1 = require("mocha");
const test_utils_1 = require("../../../test-utils");
const SNodeAPI = __importStar(require("../../../../bchat/apis/snode_api"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const onions_1 = require("../../../../bchat/onions");
const onions_2 = require("../../../../bchat/apis/snode_api/onions");
const abort_controller_1 = __importDefault(require("abort-controller"));
const Data = __importStar(require("../../../../data/data"));
const DataItem = __importStar(require("../../../../data/channelsItem"));
const onionPath_1 = require("../../../../bchat/onions/onionPath");
const seed_node_api_1 = require("../../../../bchat/apis/seed_node_api");
const utils_1 = require("../../../test-utils/utils");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
const getFakeResponseOnPath = (statusCode, body) => {
    return {
        status: statusCode || 0,
        text: async () => body || '',
    };
};
const getFakeResponseOnDestination = (statusCode, body) => {
    return {
        status: 200 || 0,
        text: async () => {
            return JSON.stringify({ status: statusCode, body: body || '' });
        },
    };
};
(0, mocha_1.describe)('OnionPathsErrors', () => {
    let updateSwarmSpy;
    let dropSnodeFromSwarmIfNeededSpy;
    let dropSnodeFromSnodePool;
    let dropSnodeFromPathSpy;
    let incrementBadPathCountOrDropSpy;
    let incrementBadSnodeCountOrDropSpy;
    let updateGuardNodesStub;
    let guardPubkeys, otherNodesPubkeys, guardNodesArray, guardSnode1, otherNodesArray, fakeSnodePool, associatedWith, fakeSwarmForAssociatedWith;
    let oldOnionPaths;
    beforeEach(async () => {
        test_utils_1.TestUtils.stubWindowLog();
        guardPubkeys = test_utils_1.TestUtils.generateFakePubKeys(3).map(n => n.key);
        otherNodesPubkeys = test_utils_1.TestUtils.generateFakePubKeys(20).map(n => n.key);
        SNodeAPI.Onions.resetSnodeFailureCount();
        guardNodesArray = guardPubkeys.map(utils_1.generateFakeSnodeWithEdKey);
        guardSnode1 = guardNodesArray[0];
        otherNodesArray = otherNodesPubkeys.map(utils_1.generateFakeSnodeWithEdKey);
        fakeSnodePool = [...guardNodesArray, ...otherNodesArray];
        associatedWith = test_utils_1.TestUtils.generateFakePubKey().key;
        fakeSwarmForAssociatedWith = otherNodesPubkeys.slice(0, 6);
        sinon_1.default.stub(onions_1.OnionPaths, 'selectGuardNodes').resolves(guardNodesArray);
        sinon_1.default.stub(SNodeAPI.SNodeAPI, 'TEST_getSnodePoolFromSnode').resolves(guardNodesArray);
        test_utils_1.TestUtils.stubData('getGuardNodes').resolves([
            guardPubkeys[0],
            guardPubkeys[1],
            guardPubkeys[2],
        ]);
        test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => ['seednode1']);
        sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(fakeSnodePool);
        sinon_1.default.stub(Data, 'getSwarmNodesForPubkey').resolves(fakeSwarmForAssociatedWith);
        updateGuardNodesStub = sinon_1.default.stub(Data, 'updateGuardNodes').resolves();
        updateSwarmSpy = sinon_1.default.stub(Data, 'updateSwarmNodesForPubkey').resolves();
        sinon_1.default.stub(DataItem, 'getItemById')
            .withArgs(Data.SNODE_POOL_ITEM_ID)
            .resolves({ id: Data.SNODE_POOL_ITEM_ID, value: '' });
        sinon_1.default.stub(DataItem, 'createOrUpdateItem').resolves();
        dropSnodeFromSnodePool = sinon_1.default.spy(SNodeAPI.SnodePool, 'dropSnodeFromSnodePool');
        dropSnodeFromSwarmIfNeededSpy = sinon_1.default.spy(SNodeAPI.SnodePool, 'dropSnodeFromSwarmIfNeeded');
        dropSnodeFromPathSpy = sinon_1.default.spy(onions_1.OnionPaths, 'dropSnodeFromPath');
        incrementBadPathCountOrDropSpy = sinon_1.default.spy(onions_1.OnionPaths, 'incrementBadPathCountOrDrop');
        incrementBadSnodeCountOrDropSpy = sinon_1.default.spy(SNodeAPI.Onions, 'incrementBadSnodeCountOrDrop');
        onions_1.OnionPaths.clearTestOnionPath();
        onions_1.OnionPaths.resetPathFailureCount();
        await onions_1.OnionPaths.getOnionPath({});
        oldOnionPaths = onions_1.OnionPaths.TEST_getTestOnionPath();
        sinon_1.default.stub(SNodeAPI.Onions, 'decodeOnionResult').callsFake((_symkey, plaintext) => Promise.resolve({ plaintext, ciphertextBuffer: new Uint8Array() }));
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
    (0, mocha_1.describe)('processOnionResponse', () => {
        it('throws a non-retryable error when the request is aborted', async () => {
            const abortController = new abort_controller_1.default();
            abortController.abort();
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnPath(),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                });
                throw new Error('Error expected');
            }
            catch (e) {
                expect(e.message).to.equal('Request got aborted');
                expect(e.name).to.equal('AbortError');
            }
        });
        it('does not throw if we get 200 on path and destination', async () => {
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnDestination(200),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                });
                throw new Error('Did not throw');
            }
            catch (e) {
                expect(e.message).to.equal('Did not throw');
            }
            expect(dropSnodeFromSnodePool.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
            expect(dropSnodeFromPathSpy.callCount).to.eq(0);
            expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(0);
        });
        it('does not throw if we get 200 on path but no status code on destination', async () => {
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnDestination(),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                });
                throw new Error('Did not throw');
            }
            catch (e) {
                expect(e.message).to.equal('Did not throw');
            }
            expect(dropSnodeFromSnodePool.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
            expect(dropSnodeFromPathSpy.callCount).to.eq(0);
            expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(0);
        });
        (0, mocha_1.describe)('processOnionResponse - 406', () => {
            it('throws an non retryable error we get a 406 on path', async () => {
                try {
                    await (0, onions_2.processOnionResponse)({
                        response: getFakeResponseOnPath(406),
                        symmetricKey: new Uint8Array(),
                        guardNode: guardSnode1,
                    });
                    throw new Error('Error expected');
                }
                catch (e) {
                    expect(e.message).to.equal('Your clock is out of sync with the network. Check your clock.');
                    expect(e.name).to.equal('AbortError');
                }
                expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
                expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(0);
            });
            it('throws an non retryable error we get a 406 on destination', async () => {
                try {
                    await (0, onions_2.processOnionResponse)({
                        response: getFakeResponseOnDestination(406),
                        symmetricKey: new Uint8Array(),
                        guardNode: guardSnode1,
                    });
                    throw new Error('Error expected');
                }
                catch (e) {
                    expect(e.message).to.equal('Your clock is out of sync with the network. Check your clock.');
                    expect(e.name).to.equal('AbortError');
                }
                expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
                expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(0);
            });
        });
        (0, mocha_1.describe)('processOnionResponse - 421', () => {
            (0, mocha_1.describe)('processOnionResponse - 421 - on path', () => {
                it('throws a non-retryable error if we get a 421 status code without new swarm', async () => {
                    const targetNode = otherNodesPubkeys[0];
                    try {
                        await (0, onions_2.processOnionResponse)({
                            response: getFakeResponseOnPath(421),
                            symmetricKey: new Uint8Array(),
                            guardNode: guardSnode1,
                            lsrpcEd25519Key: targetNode,
                            associatedWith,
                        });
                        throw new Error('Error expected');
                    }
                    catch (e) {
                        expect(e.message).to.equal('421 handled. Retry this request with a new targetNode');
                        expect(e.name).to.equal('AbortError');
                    }
                    expect(updateSwarmSpy.callCount).to.eq(1);
                    expect(updateSwarmSpy.args[0][1]).to.deep.eq(fakeSwarmForAssociatedWith.filter(m => m !== targetNode));
                    expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(1);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[0]).to.eq(associatedWith);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[1]).to.eq(targetNode);
                    expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                    expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                    expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                    expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(1);
                    expect(incrementBadSnodeCountOrDropSpy.firstCall.args[0]).to.deep.eq({
                        snodeEd25519: targetNode,
                        associatedWith,
                    });
                });
            });
            (0, mocha_1.describe)('processOnionResponse - 421 - on destination', () => {
                it('throws a non-retryable error we get a 421 status code with a new swarm', async () => {
                    const targetNode = otherNodesPubkeys[0];
                    const resultExpected = [
                        otherNodesArray[4],
                        otherNodesArray[5],
                        otherNodesArray[6],
                    ];
                    try {
                        await (0, onions_2.processOnionResponse)({
                            response: getFakeResponseOnDestination(421, JSON.stringify({ snodes: resultExpected })),
                            symmetricKey: new Uint8Array(),
                            guardNode: guardSnode1,
                            lsrpcEd25519Key: targetNode,
                            associatedWith,
                        });
                        throw new Error('Error expected');
                    }
                    catch (e) {
                        expect(e.message).to.equal('421 handled. Retry this request with a new targetNode');
                        expect(e.name).to.equal('AbortError');
                    }
                    expect(updateSwarmSpy.callCount).to.eq(1);
                    expect(updateSwarmSpy.args[0][1]).to.deep.eq(resultExpected.map(m => m.pubkey_ed25519));
                    expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                    expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                    expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                    expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(1);
                    expect(incrementBadSnodeCountOrDropSpy.firstCall.args[0]).to.deep.eq({
                        snodeEd25519: targetNode,
                        associatedWith,
                    });
                });
                it('throws a non-retryable error we get a 421 status code with invalid json body', async () => {
                    const targetNode = otherNodesPubkeys[0];
                    try {
                        await (0, onions_2.processOnionResponse)({
                            response: getFakeResponseOnDestination(421, 'THIS IS SOME INVALID JSON'),
                            symmetricKey: new Uint8Array(),
                            guardNode: guardSnode1,
                            lsrpcEd25519Key: targetNode,
                            associatedWith,
                        });
                        throw new Error('Error expected');
                    }
                    catch (e) {
                        expect(e.message).to.equal('421 handled. Retry this request with a new targetNode');
                        expect(e.name).to.equal('AbortError');
                    }
                    expect(updateSwarmSpy.callCount).to.eq(1);
                    expect(updateSwarmSpy.args[0][1]).to.deep.eq(fakeSwarmForAssociatedWith.filter(m => m !== targetNode));
                    expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(1);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[0]).to.eq(associatedWith);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[1]).to.eq(targetNode);
                    expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                    expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                    expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                    expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(1);
                    expect(incrementBadSnodeCountOrDropSpy.firstCall.args[0]).to.deep.eq({
                        snodeEd25519: targetNode,
                        associatedWith,
                    });
                });
                it('throws a non-retryable on destination 421 without new swarm ', async () => {
                    const targetNode = otherNodesPubkeys[0];
                    const json = JSON.stringify({ status: 421 });
                    try {
                        await (0, onions_2.processOnionResponse)({
                            response: getFakeResponseOnDestination(421, json),
                            symmetricKey: new Uint8Array(),
                            guardNode: guardSnode1,
                            lsrpcEd25519Key: targetNode,
                            associatedWith,
                        });
                        throw new Error('Error expected');
                    }
                    catch (e) {
                        expect(e.message).to.equal('421 handled. Retry this request with a new targetNode');
                        expect(e.name).to.equal('AbortError');
                    }
                    expect(updateSwarmSpy.callCount).to.eq(1);
                    expect(updateSwarmSpy.args[0][1]).to.deep.eq(fakeSwarmForAssociatedWith.filter(m => m !== targetNode));
                    expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(1);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[0]).to.eq(associatedWith);
                    expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[1]).to.eq(targetNode);
                    expect(dropSnodeFromSnodePool.callCount).to.eq(0);
                    expect(dropSnodeFromPathSpy.callCount).to.eq(0);
                    expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
                    expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(1);
                    expect(incrementBadSnodeCountOrDropSpy.firstCall.args[0]).to.deep.eq({
                        snodeEd25519: targetNode,
                        associatedWith,
                    });
                });
            });
        });
    });
    (0, mocha_1.describe)('processOnionResponse - OXEN_SERVER_ERROR', () => {
        it('throws a non-retryable error on oxen server errors on destination', async () => {
            const targetNode = otherNodesPubkeys[0];
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnDestination(400, onions_2.OXEN_SERVER_ERROR),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                    lsrpcEd25519Key: targetNode,
                    associatedWith,
                });
                throw new Error('Error expected');
            }
            catch (e) {
                expect(e.message).to.equal(onions_2.OXEN_SERVER_ERROR);
                expect(e.name).to.equal('AbortError');
            }
            expect(updateSwarmSpy.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
            expect(dropSnodeFromSnodePool.callCount).to.eq(0);
            expect(dropSnodeFromPathSpy.callCount).to.eq(0);
            expect(incrementBadPathCountOrDropSpy.callCount).to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(0);
        });
    });
    (0, mocha_1.describe)('processOnionResponse - 502 - node not found', () => {
        it('throws a retryable error on 502 on intermediate snode', async () => {
            const targetNode = otherNodesPubkeys[0];
            const failingSnode = oldOnionPaths[0][1];
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnPath(502, `${onions_2.NEXT_NODE_NOT_FOUND_PREFIX}${failingSnode.pubkey_ed25519}`),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                    lsrpcEd25519Key: targetNode,
                    associatedWith,
                });
                throw new Error('Error expected');
            }
            catch (e) {
                expect(e.message).to.equal('Bad Path handled. Retry this request. Status: 502');
                expect(e.name).to.not.equal('AbortError');
            }
            expect(updateSwarmSpy.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount, 'dropSnodeFromSwarmIfNeededSpy should have been called').to.eq(1);
            expect(dropSnodeFromSnodePool.callCount, 'dropSnodeFromSnodePool should have been called').to.eq(1);
            expect(dropSnodeFromPathSpy.callCount, 'dropSnodeFromPath should have been called').to.eq(1);
            expect(incrementBadPathCountOrDropSpy.callCount, 'incrementBadPathCountOrDrop should not have been called').to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount, 'incrementBadSnodeCountOrDrop should not have been called').to.eq(0);
        });
        it('throws a retryable error on 502 on last snode', async () => {
            const targetNode = otherNodesPubkeys[0];
            const failingSnode = oldOnionPaths[0][2];
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnPath(502, `${onions_2.NEXT_NODE_NOT_FOUND_PREFIX}${failingSnode.pubkey_ed25519}`),
                    symmetricKey: new Uint8Array(),
                    guardNode: guardSnode1,
                    lsrpcEd25519Key: targetNode,
                    associatedWith,
                });
                throw new Error('Error expected');
            }
            catch (e) {
                expect(e.message).to.equal('Bad Path handled. Retry this request. Status: 502');
                expect(e.name).to.not.equal('AbortError');
            }
            expect(updateSwarmSpy.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(1);
            expect(dropSnodeFromSnodePool.callCount, 'dropSnodeFromSnodePool should have been called').to.eq(1);
            expect(dropSnodeFromPathSpy.callCount, 'dropSnodeFromPath should have been called').to.eq(1);
            expect(incrementBadPathCountOrDropSpy.callCount, 'incrementBadPathCountOrDrop should not have been called').to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount, 'incrementBadSnodeCountOrDrop should not have been called').to.eq(0);
        });
        it('drop a snode from pool, swarm and path if it keep failing', async () => {
            const targetNode = otherNodesPubkeys[0];
            const failingSnode = oldOnionPaths[0][1];
            for (let index = 0; index < 3; index++) {
                try {
                    await (0, onions_2.processOnionResponse)({
                        response: getFakeResponseOnPath(502, `${onions_2.NEXT_NODE_NOT_FOUND_PREFIX}${failingSnode.pubkey_ed25519}`),
                        symmetricKey: new Uint8Array(),
                        guardNode: guardSnode1,
                        lsrpcEd25519Key: targetNode,
                        associatedWith,
                    });
                    throw new Error('Error expected');
                }
                catch (e) {
                    expect(e.message).to.equal('Bad Path handled. Retry this request. Status: 502');
                    expect(e.name).to.not.equal('AbortError');
                }
            }
            expect(updateSwarmSpy.callCount).to.eq(0);
            expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(3);
            expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[0]).to.eq(associatedWith);
            expect(dropSnodeFromSwarmIfNeededSpy.firstCall.args[1]).to.eq(failingSnode.pubkey_ed25519);
            expect(dropSnodeFromSnodePool.callCount, 'dropSnodeFromSnodePool should have been called').to.eq(3);
            expect(dropSnodeFromPathSpy.callCount, 'dropSnodeFromPath should have been called').to.eq(3);
            expect(incrementBadPathCountOrDropSpy.callCount, 'incrementBadPathCountOrDrop should not have been called').to.eq(0);
            expect(incrementBadSnodeCountOrDropSpy.callCount, 'incrementBadSnodeCountOrDrop should not have been called').to.eq(0);
        });
    });
    it('drop a path if it keep failing without a specific node in fault', async () => {
        const targetNode = otherNodesPubkeys[0];
        const guardNode = oldOnionPaths[0][0];
        for (let index = 0; index < 3; index++) {
            try {
                await (0, onions_2.processOnionResponse)({
                    response: getFakeResponseOnPath(500),
                    symmetricKey: new Uint8Array(),
                    guardNode,
                    lsrpcEd25519Key: targetNode,
                    associatedWith,
                });
                throw new Error('Error expected');
            }
            catch (e) {
                expect(e.message).to.equal('Bad Path handled. Retry this request. Status: 500');
                expect(e.name).to.not.equal('AbortError');
                if (index < 2) {
                    expect(onionPath_1.pathFailureCount[guardNode.pubkey_ed25519]).to.eq(index + 1);
                }
                else {
                    expect(onionPath_1.pathFailureCount[guardNode.pubkey_ed25519]).to.eq(0);
                }
            }
        }
        expect(incrementBadPathCountOrDropSpy.callCount).to.eq(3);
        expect(incrementBadSnodeCountOrDropSpy.callCount).to.eq(2 * 3);
        for (let index = 0; index < 6; index++) {
            expect(incrementBadSnodeCountOrDropSpy.args[index][0]).to.deep.eq({
                snodeEd25519: oldOnionPaths[0][(index % 2) + 1].pubkey_ed25519,
            });
        }
        expect(updateGuardNodesStub.callCount).to.eq(1);
        expect(dropSnodeFromSwarmIfNeededSpy.callCount).to.eq(0);
        expect(guardNode.pubkey_ed25519).to.eq(incrementBadPathCountOrDropSpy.args[0][0]);
        expect(guardNode.pubkey_ed25519).to.eq(incrementBadPathCountOrDropSpy.args[1][0]);
        expect(guardNode.pubkey_ed25519).to.eq(incrementBadPathCountOrDropSpy.args[2][0]);
        expect(dropSnodeFromPathSpy.callCount).to.eq(2);
        expect(dropSnodeFromSnodePool.callCount).to.eq(3);
        expect(dropSnodeFromSnodePool.args[0][0]).to.eq(oldOnionPaths[0][1].pubkey_ed25519);
        expect(dropSnodeFromSnodePool.args[1][0]).to.eq(oldOnionPaths[0][2].pubkey_ed25519);
        expect(dropSnodeFromSnodePool.args[2][0]).to.eq(oldOnionPaths[0][0].pubkey_ed25519);
    });
});
