"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const lodash_1 = __importDefault(require("lodash"));
const mocha_1 = require("mocha");
const test_utils_1 = require("../../../test-utils");
const SNodeAPI = __importStar(require("../../../../bchat/apis/snode_api"));
const Data = __importStar(require("../../../../data/data"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const OnionPaths = __importStar(require("../../../../bchat/onions/onionPath"));
const utils_1 = require("../../../test-utils/utils");
const seed_node_api_1 = require("../../../../bchat/apis/seed_node_api");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
const guard1ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534e';
const guard2ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f91615349';
const guard3ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534a';
const fakeSnodePool = [
    ...(0, utils_1.generateFakeSnodes)(12),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard1ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard2ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard3ed),
    ...(0, utils_1.generateFakeSnodes)(9),
];
const fakeGuardNodesEd25519 = [guard1ed, guard2ed, guard3ed];
const fakeGuardNodes = fakeSnodePool.filter(m => fakeGuardNodesEd25519.includes(m.pubkey_ed25519));
const fakeGuardNodesFromDB = fakeGuardNodesEd25519.map(ed25519PubKey => {
    return {
        ed25519PubKey,
    };
});
(0, mocha_1.describe)('OnionPaths', () => {
    let oldOnionPaths;
    (0, mocha_1.describe)('dropSnodeFromPath', () => {
        beforeEach(async () => {
            OnionPaths.clearTestOnionPath();
            sinon_1.default.stub(OnionPaths, 'selectGuardNodes').resolves(fakeGuardNodes);
            sinon_1.default.stub(SNodeAPI.SNodeAPI, 'TEST_getSnodePoolFromSnode').resolves(fakeGuardNodes);
            sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(fakeSnodePool);
            test_utils_1.TestUtils.stubData('getGuardNodes').resolves(fakeGuardNodesFromDB);
            test_utils_1.TestUtils.stubData('createOrUpdateItem').resolves();
            test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => ['seednode1']);
            test_utils_1.TestUtils.stubWindowLog();
            sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(fakeSnodePool);
            SNodeAPI.Onions.resetSnodeFailureCount();
            OnionPaths.resetPathFailureCount();
            await OnionPaths.getOnionPath({});
            oldOnionPaths = OnionPaths.TEST_getTestOnionPath();
            if (oldOnionPaths.length !== 3) {
                throw new Error(`onion path length not enough ${oldOnionPaths.length}`);
            }
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        (0, mocha_1.describe)('with valid snode pool', () => {
            it('rebuilds after removing last snode on path', async () => {
                await OnionPaths.dropSnodeFromPath(oldOnionPaths[2][2].pubkey_ed25519);
                const newOnionPath = OnionPaths.TEST_getTestOnionPath();
                expect(newOnionPath).to.be.not.deep.equal(oldOnionPaths);
                expect(newOnionPath[0]).to.be.deep.equal(oldOnionPaths[0]);
                expect(newOnionPath[1]).to.be.deep.equal(oldOnionPaths[1]);
                expect(newOnionPath[2][0]).to.be.deep.equal(oldOnionPaths[2][0]);
                expect(newOnionPath[2][1]).to.be.deep.equal(oldOnionPaths[2][1]);
                expect(newOnionPath[2][2]).to.be.not.deep.equal(oldOnionPaths[2][2]);
            });
            it('rebuilds after removing middle snode on path', async () => {
                await OnionPaths.dropSnodeFromPath(oldOnionPaths[2][1].pubkey_ed25519);
                const newOnionPath = OnionPaths.TEST_getTestOnionPath();
                const allEd25519Keys = lodash_1.default.flattenDeep(oldOnionPaths).map(m => m.pubkey_ed25519);
                expect(newOnionPath).to.be.not.deep.equal(oldOnionPaths);
                expect(newOnionPath[0]).to.be.deep.equal(oldOnionPaths[0]);
                expect(newOnionPath[1]).to.be.deep.equal(oldOnionPaths[1]);
                expect(newOnionPath[2][0]).to.be.deep.equal(oldOnionPaths[2][0]);
                expect(newOnionPath[2][1]).to.be.deep.equal(oldOnionPaths[2][2]);
                expect(allEd25519Keys).to.not.include(newOnionPath[2][2].pubkey_ed25519);
            });
        });
    });
});
