"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const mocha_1 = require("mocha");
const test_utils_1 = require("../../../test-utils");
const snode_api_1 = require("../../../../bchat/apis/snode_api");
const Data = __importStar(require("../../../../data/data"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const OnionPaths = __importStar(require("../../../../bchat/onions/onionPath"));
const utils_1 = require("../../../test-utils/utils");
const seed_node_api_1 = require("../../../../bchat/apis/seed_node_api");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
const guard1ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534e';
const guard2ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f91615349';
const guard3ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534a';
const fakeSnodePool = [
    ...(0, utils_1.generateFakeSnodes)(12),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard1ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard2ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard3ed),
    ...(0, utils_1.generateFakeSnodes)(3),
];
(0, mocha_1.describe)('OnionPaths', () => {
    (0, mocha_1.describe)('getSnodePoolFromDBOrFetchFromSeed', () => {
        let getSnodePoolFromDb;
        let fetchFromSeedWithRetriesAndWriteToDb;
        let fetchSnodePoolFromSeedNodeWithRetries;
        beforeEach(() => {
            OnionPaths.clearTestOnionPath();
            test_utils_1.TestUtils.stubWindow('getSeedNodeList', () => ['seednode1']);
            test_utils_1.TestUtils.stubWindowLog();
            snode_api_1.Onions.resetSnodeFailureCount();
            OnionPaths.resetPathFailureCount();
            snode_api_1.SnodePool.TEST_resetState();
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        it('if the cached snode pool has at least 12 snodes, just return it without fetching from seed', async () => {
            getSnodePoolFromDb = sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(fakeSnodePool);
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(snode_api_1.SnodePool, 'TEST_fetchFromSeedWithRetriesAndWriteToDb');
            const fetched = await snode_api_1.SnodePool.getSnodePoolFromDBOrFetchFromSeed();
            expect(getSnodePoolFromDb.callCount).to.be.eq(1);
            expect(fetchFromSeedWithRetriesAndWriteToDb.callCount).to.be.eq(0);
            expect(fetched).to.deep.equal(fakeSnodePool);
        });
        it('if the cached snode pool 12 or less snodes, trigger a fetch from the seed nodes', async () => {
            const length12 = fakeSnodePool.slice(0, 12);
            expect(length12.length).to.eq(12);
            getSnodePoolFromDb = sinon_1.default.stub(Data, 'getSnodePoolFromDb').resolves(length12);
            sinon_1.default.stub(Data, 'updateSnodePoolOnDb').resolves();
            fetchFromSeedWithRetriesAndWriteToDb = sinon_1.default.stub(snode_api_1.SnodePool, 'TEST_fetchFromSeedWithRetriesAndWriteToDb').callThrough();
            fetchSnodePoolFromSeedNodeWithRetries = sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'fetchSnodePoolFromSeedNodeWithRetries').resolves(fakeSnodePool);
            const fetched = await snode_api_1.SnodePool.getSnodePoolFromDBOrFetchFromSeed();
            expect(getSnodePoolFromDb.callCount).to.be.eq(1);
            expect(fetchFromSeedWithRetriesAndWriteToDb.callCount, 'fetchFromSeedWithRetriesAndWriteToDb eq 1').to.be.eq(1);
            expect(fetchSnodePoolFromSeedNodeWithRetries.callCount, 'fetchSnodePoolFromSeedNodeWithRetries eq 1').to.be.eq(1);
            expect(fetched).to.deep.equal(fakeSnodePool);
        });
    });
});
