"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const mocha_1 = require("mocha");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const BufferPadding_1 = require("../../../../bchat/crypto/BufferPadding");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
(0, mocha_1.describe)('Padding', () => {
    (0, mocha_1.describe)('Attachment padding', () => {
        it('add padding', () => {
            const bufferIn = new Uint8Array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9]);
            const paddedBuffer = (0, BufferPadding_1.addAttachmentPadding)(bufferIn);
            expect(paddedBuffer.byteLength).to.equal(541);
            expect(new Uint8Array(paddedBuffer.slice(0, bufferIn.length))).to.equalBytes(bufferIn);
            expect(new Uint8Array(paddedBuffer.slice(bufferIn.length))).to.equalBytes(new Uint8Array(541 - bufferIn.length));
        });
        it('remove padding', () => {
            const expectedSize = 10;
            const paddedBuffer = new Uint8Array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 5]);
            const paddingRemoveBuffer = (0, BufferPadding_1.getUnpaddedAttachment)(paddedBuffer, expectedSize);
            expect(paddingRemoveBuffer?.byteLength).to.equal(expectedSize);
            expect(paddingRemoveBuffer).to.equalBytes(paddedBuffer.slice(0, expectedSize));
        });
    });
    (0, mocha_1.describe)('Message padding', () => {
        it('add padding', () => {
            const bufferIn = new Uint8Array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9]);
            const paddedMessage = (0, BufferPadding_1.addMessagePadding)(bufferIn);
            expect(paddedMessage.byteLength).to.equal(159);
            expect(new Uint8Array(paddedMessage.slice(0, bufferIn.length))).to.equalBytes(bufferIn);
            expect(paddedMessage[bufferIn.length]).to.equal(0x80);
            expect(new Uint8Array(paddedMessage.slice(bufferIn.length + 1))).to.equalBytes(new Uint8Array(159 - bufferIn.length - 1));
        });
        it('remove padding', () => {
            const expectedSize = 10;
            const paddedBuffer = new Uint8Array([
                0,
                1,
                2,
                3,
                4,
                5,
                6,
                7,
                8,
                9,
                128,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ]);
            const unpaddedMessage = (0, BufferPadding_1.removeMessagePadding)(paddedBuffer);
            expect(unpaddedMessage?.byteLength).to.equal(expectedSize);
            expect(new Uint8Array(unpaddedMessage)).to.equalBytes(paddedBuffer.slice(0, expectedSize));
        });
    });
});
