"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importStar(require("chai"));
const mocha_1 = require("mocha");
const path_1 = __importDefault(require("path"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const privacy_1 = require("../../../../util/privacy");
chai_1.default.use(chai_as_promised_1.default);
(0, mocha_1.describe)('Privacy', () => {
    (0, mocha_1.describe)('Redact bchatID', () => {
        it('redact bchatID', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('052d3096a72d2271bbba0d820729a3548749a2b3890c3b41ea08c4c2722616dd2b')).to.be.equal('[REDACTED]');
        });
        it('redact multiple bchatID', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('052d3096a72d2271bbba0d820729a3548749a2b3890c3b41ea08c4c2722616dd2b 052d3096a72d2271bbba0d820729a3548749a2b3890c3b41ea08c4c2722616dd2c end')).to.be.equal('[REDACTED] [REDACTED] end');
        });
        it('redact bchatID without the 05 prefix', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('start 2d3096a72d2271bbba0d820729a3548749a2b3890c3b41ea08c4c2722616dd2b middle 2d3096a72d2271bbba0d820729a3548749a2b3890c3b41ea08c4c2722616dd2c end')).to.be.equal('start [REDACTED] middle [REDACTED] end');
        });
    });
    (0, mocha_1.describe)('Redact serverUrl', () => {
        it('redact serverUrl https no port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('https://example.org')).to.be.equal('[REDACTED]');
        });
        it('redact serverUrl http no port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('http://example.org')).to.be.equal('[REDACTED]');
        });
        it('redact serverUrl https with port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('https://example.org:8080')).to.be.equal('[REDACTED]');
        });
        it('redact serverUrl http with port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('http://example.org:8001')).to.be.equal('[REDACTED]');
        });
        it('redact serverUrl http with port keep rest of content', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('start http://example.org:8001 end')).to.be.equal('start [REDACTED] end');
        });
        it('redact multiple serverUrl http with port keep rest of content', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('start http://example.org:8001 http://bchat.beldex.io end')).to.be.equal('start [REDACTED] [REDACTED] end');
        });
    });
    (0, mocha_1.describe)('Redact snodeIP', () => {
        it('redact snodeIP no port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('127.0.0.1')).to.be.equal('[REDACTED]');
        });
        it('redact snodeIP with port', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('127.0.0.1:22')).to.be.equal('[REDACTED]:22');
        });
        it('redact snodeIP with port multiple', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('127.0.0.1:8098 127.0.0.1:22 127.0.0.1')).to.be.equal('[REDACTED]:8098 [REDACTED]:22 [REDACTED]');
        });
        it('redact snodeIP with port multiple but keep rest of content', () => {
            (0, chai_1.expect)((0, privacy_1.redactAll)('start 127.0.0.1:2212 127.0.0.1:2200 middle 127.0.0.1 end')).to.be.equal('start [REDACTED]:2212 [REDACTED]:2200 middle [REDACTED] end');
        });
    });
    (0, mocha_1.describe)('Redact app path', () => {
        it('removes whatever is in front of the app root path before logging', () => {
            const appRootPath = path_1.default.join(__dirname, '..', '..', '..', '..', '..');
            (0, chai_1.expect)((0, privacy_1.redactAll)(path_1.default.join(appRootPath, 'whatever'))).to.be.be.oneOf([
                '[REDACTED]/whatever',
                '[REDACTED]\\whatever',
            ]);
        });
    });
});
