"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const ConfigurationMessage_1 = require("../../../../bchat/messages/outgoing/controlMessage/ConfigurationMessage");
const utils_1 = require("../../../../bchat/utils");
const test_utils_1 = require("../../../test-utils");
const sinon_1 = __importDefault(require("sinon"));
const cache = __importStar(require("../../../../receiver/cache"));
const data = __importStar(require("../../../../data/data"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const configMessage_1 = require("../../../../receiver/configMessage");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
describe('ConfigurationMessage_receiving', () => {
    let createOrUpdateStub;
    let getItemByIdStub;
    let sender;
    let envelope;
    let config;
    beforeEach(() => {
        sinon_1.default.stub(cache, 'removeFromCache').resolves();
        sender = test_utils_1.TestUtils.generateFakePubKey().key;
        config = new ConfigurationMessage_1.ConfigurationMessage({
            activeOpenGroups: [],
            activeClosedGroups: [],
            timestamp: Date.now(),
            identifier: 'identifier',
            displayName: 'displayName',
            contacts: [],
        });
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
    it('should not be processed if we do not have a pubkey', async () => {
        sinon_1.default.stub(utils_1.UserUtils, 'getOurPubKeyStrFromCache').resolves(undefined);
        envelope = test_utils_1.TestUtils.generateEnvelopePlus(sender);
        const proto = config.contentProto();
        createOrUpdateStub = sinon_1.default.stub(data, 'createOrUpdateItem').resolves();
        getItemByIdStub = sinon_1.default.stub(data, 'getItemById').resolves();
        await (0, configMessage_1.handleConfigurationMessage)(envelope, proto.configurationMessage);
        expect(createOrUpdateStub.callCount).to.equal(0);
        expect(getItemByIdStub.callCount).to.equal(0);
    });
    describe('with ourNumber set', () => {
        const ourNumber = test_utils_1.TestUtils.generateFakePubKey().key;
        beforeEach(() => {
            sinon_1.default.stub(utils_1.UserUtils, 'getOurPubKeyStrFromCache').resolves(ourNumber);
        });
        it('should not be processed if the message is not coming from our number', async () => {
            const proto = config.contentProto();
            envelope = test_utils_1.TestUtils.generateEnvelopePlus(sender);
            createOrUpdateStub = sinon_1.default.stub(data, 'createOrUpdateItem').resolves();
            getItemByIdStub = sinon_1.default.stub(data, 'getItemById').resolves();
            await (0, configMessage_1.handleConfigurationMessage)(envelope, proto.configurationMessage);
            expect(createOrUpdateStub.callCount).to.equal(0);
            expect(getItemByIdStub.callCount).to.equal(0);
        });
    });
});
