"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const conversation_1 = require("../../../../models/conversation");
const conversations_1 = require("../../../../state/selectors/conversations");
describe('state/selectors/conversations', () => {
    describe('#getSortedConversationsList', () => {
        it('sorts conversations based on timestamp then by intl-friendly title', () => {
            const i18n = (key) => key;
            const data = {
                id1: {
                    id: 'id1',
                    activeAt: 0,
                    name: 'No timestamp',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    hasNickname: false,
                    isPublic: false,
                    subscriberCount: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    expireTimer: 0,
                    isPinned: false,
                },
                id2: {
                    id: 'id2',
                    activeAt: 20,
                    name: 'B',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    hasNickname: false,
                    isPublic: false,
                    subscriberCount: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    expireTimer: 0,
                    isPinned: false,
                },
                id3: {
                    id: 'id3',
                    activeAt: 20,
                    name: 'C',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    hasNickname: false,
                    isPublic: false,
                    subscriberCount: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    expireTimer: 0,
                    isPinned: false,
                },
                id4: {
                    id: 'id4',
                    activeAt: 20,
                    name: 'Á',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    hasNickname: false,
                    isPublic: false,
                    subscriberCount: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    expireTimer: 0,
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: false,
                },
                id5: {
                    id: 'id5',
                    activeAt: 30,
                    name: 'First!',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    hasNickname: false,
                    isPublic: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: false,
                },
            };
            const comparator = (0, conversations_1._getConversationComparator)(i18n);
            const conversations = (0, conversations_1._getSortedConversations)(data, comparator);
            chai_1.assert.strictEqual(conversations[0].name, 'First!');
            chai_1.assert.strictEqual(conversations[1].name, 'Á');
            chai_1.assert.strictEqual(conversations[2].name, 'B');
            chai_1.assert.strictEqual(conversations[3].name, 'C');
        });
    });
    describe('#getSortedConversationsWithPinned', () => {
        it('sorts conversations based on pin, timestamp then by intl-friendly title', () => {
            const i18n = (key) => key;
            const data = {
                id1: {
                    id: 'id1',
                    activeAt: 0,
                    name: 'No timestamp',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: false,
                    hasNickname: false,
                    isPublic: false,
                },
                id2: {
                    id: 'id2',
                    activeAt: 20,
                    name: 'B',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: false,
                    hasNickname: false,
                    isPublic: false,
                },
                id3: {
                    id: 'id3',
                    activeAt: 20,
                    name: 'C',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: true,
                    hasNickname: false,
                    isPublic: false,
                },
                id4: {
                    id: 'id4',
                    activeAt: 20,
                    name: 'Á',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: true,
                    hasNickname: false,
                    isPublic: false,
                },
                id5: {
                    id: 'id5',
                    activeAt: 30,
                    name: 'First!',
                    type: conversation_1.ConversationTypeEnum.PRIVATE,
                    isMe: false,
                    unreadCount: 1,
                    mentionedUs: false,
                    isSelected: false,
                    isTyping: false,
                    isBlocked: false,
                    isKickedFromGroup: false,
                    left: false,
                    subscriberCount: 0,
                    expireTimer: 0,
                    currentNotificationSetting: 'all',
                    weAreAdmin: false,
                    isGroup: false,
                    isPrivate: false,
                    avatarPath: '',
                    groupAdmins: [],
                    lastMessage: undefined,
                    members: [],
                    profileName: 'df',
                    isPinned: false,
                    hasNickname: false,
                    isPublic: false,
                },
            };
            const comparator = (0, conversations_1._getConversationComparator)(i18n);
            const conversations = (0, conversations_1._getSortedConversations)(data, comparator);
            chai_1.assert.strictEqual(conversations[0].name, 'Á');
            chai_1.assert.strictEqual(conversations[1].name, 'C');
            chai_1.assert.strictEqual(conversations[2].name, 'First!');
            chai_1.assert.strictEqual(conversations[3].name, 'B');
        });
    });
});
